/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.util;

import java.util.Arrays;

public abstract class AbstractUri {
    private final char[] value;
    private int hash;
    private int scheme;
    private int specificPart;
    private int fragment;

    public AbstractUri(char[] value) {
        this.value = value;
        this.init(value);
    }

    private void init(char[] val) {
        int i;
        for (i = 0; i < val.length && val[i] != ':'; ++i) {
        }
        this.scheme = i == val.length ? -1 : i;
        while (i < val.length && val[i] != '#') {
            ++i;
        }
        this.specificPart = i;
    }

    public final char[] getChars() {
        return this.value;
    }

    public String getScheme() {
        if (this.scheme == -1) {
            return null;
        }
        return new String(this.value, 0, this.scheme);
    }

    public String getSchemeSpecificPart() {
        return new String(this.value, this.scheme + 1, this.specificPart - this.scheme - 1);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0 && this.value.length > 0) {
            char[] val = this.value;
            for (int i = 0; i < this.value.length; ++i) {
                h = 31 * h + val[i];
            }
            this.hash = h;
        }
        return h;
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && Arrays.equals(this.value, ((AbstractUri)o).value);
    }
}

