/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.util;

import io.legaldocml.util.CharArray;
import io.legaldocml.util.CharArrays;
import io.legaldocml.util.Hashing;
import io.legaldocml.util.ImmutableCharArray;

public final class CharBuffer
implements CharArray {
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    protected char[] hb = new char[2048];
    private int pos = 0;

    public void put(char c) {
        if (this.pos == this.hb.length) {
            this.grow();
        }
        this.hb[this.pos++] = c;
    }

    @Override
    public String toString() {
        return new String(this.hb, 0, this.pos);
    }

    public int pos() {
        return this.pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public void reset() {
        this.pos = 0;
    }

    @Override
    public int length() {
        return this.pos;
    }

    @Override
    public char charAt(int index) {
        return this.hb[index];
    }

    @Override
    public CharArray subSequence(int start, int end) {
        char[] value = new char[end - start];
        System.arraycopy(this.hb, start, value, 0, value.length);
        return CharArrays.immutable(value);
    }

    @Override
    public char[] value() {
        char[] value = new char[this.pos];
        System.arraycopy(this.hb, 0, value, 0, this.pos);
        return value;
    }

    public int hashCode() {
        return (int)Hashing.xx(this.pos, this.pos, this.hb);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ImmutableCharArray) {
            ImmutableCharArray array = (ImmutableCharArray)obj;
            if (array.length() != this.pos) {
                return false;
            }
            char[] hb = this.hb;
            for (int i = 0; i < this.pos; ++i) {
                if (hb[i] == array.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public char getBefore(int i) {
        return this.hb[this.pos - i];
    }

    private void grow() {
        char[] newHb = new char[this.hb.length << 1];
        System.arraycopy(this.hb, 0, newHb, 0, this.pos);
        this.hb = newHb;
    }

    public void clean() {
        this.reset();
        if (this.hb.length > 2048) {
            this.hb = new char[2048];
        }
    }
}

