/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.util;

import io.legaldocml.unsafe.UnsafeString;
import io.legaldocml.util.CharArray;
import io.legaldocml.util.Hashing;
import java.util.Arrays;

final class ImmutableCharArray
implements CharArray {
    private final char[] c;
    private final int length;
    private int hash;

    ImmutableCharArray(char[] array) {
        this(array, array.length);
    }

    ImmutableCharArray(char[] array, int len) {
        this.c = (char[])array.clone();
        this.length = len;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        return this.c[index];
    }

    @Override
    public CharArray subSequence(int start, int end) {
        if (start == 0) {
            return new ImmutableCharArray(this.c, end);
        }
        char[] val = new char[end - start];
        System.arraycopy(this.c, start, val, 0, val.length);
        return new ImmutableCharArray(val);
    }

    @Override
    public char[] value() {
        return Arrays.copyOf(this.c, this.length);
    }

    @Override
    public String toString() {
        return UnsafeString.valueOf(this.c);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof ImmutableCharArray) {
            return this.doEquals((ImmutableCharArray)obj);
        }
        return obj instanceof CharSequence && this.doEquals((CharSequence)obj);
    }

    private boolean doEquals(CharSequence s) {
        if (this.length != s.length()) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.c[i] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private boolean doEquals(ImmutableCharArray s) {
        if (this.length != s.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.c[i] == s.c[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = (int)Hashing.xx(this.length, this.length, this.c);
        }
        return this.hash;
    }
}

