/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.util;

public final class Maths {
    private Maths() {
    }

    public static int mul10(int value) {
        return (value << 3) + (value << 1);
    }

    public static int mul100(int value) {
        return (value << 6) + (value << 5) + (value << 2);
    }

    public static int div10(int n) {
        n += n >> 31 & 9;
        int q = (n >> 1) + (n >> 2);
        q += q >> 4;
        q += q >> 8;
        q += q >> 16;
        int r = n - (((q >>= 3) << 3) + (q << 1));
        return q + (r + 6 >> 4);
    }

    public static int unsignedDiv10(int n) {
        int q = (n >> 1) + (n >> 2);
        q += q >> 4;
        q += q >> 8;
        q += q >> 16;
        int r = n - (((q >>= 3) << 3) + (q << 1));
        return q + (r + 6 >> 4);
    }

    public static int div100(int n) {
        n += n >> 31 & 0x63;
        int q = (n >> 1) + (n >> 3) + (n >> 6) - (n >> 10) + (n >> 12) + (n >> 13) - (n >> 16);
        q += q >> 20;
        int r = n - (((q >>= 6) << 6) + (q << 5) + (q << 2));
        return q + (r + 28 >> 7);
    }

    public static int unsignedDiv100(int n) {
        int q = (n >> 1) + (n >> 3) + (n >> 6) - (n >> 10) + (n >> 12) + (n >> 13) - (n >> 16);
        q += q >> 20;
        int r = n - (q >>= 6) * 100;
        return q + (r + 28 >> 7);
    }

    public static int unsignedDiv1000(int n) {
        int t = (n >> 7) + (n >> 8) + (n >> 12);
        int q = (n >> 1) + t + (n >> 15) + (t >> 11) + (t >> 14);
        int r = n - (q >>= 9) * 1000;
        return q + (r + 24 >> 10);
    }
}

