/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.util;

import io.legaldocml.io.XmlWriter;
import io.legaldocml.io.impl.Buffers;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import sun.nio.ch.DirectBuffer;

public abstract class StringWriterTemplate {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void reserveBuffer(String value) throws IOException {
        MappedByteBuffer buffer = null;
        try {
            byte[] bytes = value.getBytes(StandardCharsets.US_ASCII);
            buffer = (MappedByteBuffer)ByteBuffer.allocateDirect(bytes.length);
            buffer.put(bytes);
            buffer.flip();
            long addr = ((DirectBuffer)((Object)buffer)).address();
            this.onReserveBuffer(addr, bytes.length);
            if (buffer == null) return;
        }
        catch (Throwable throwable) {
            if (buffer == null) throw throwable;
            Buffers.releaseDirectByteBuffer(buffer);
            throw throwable;
        }
        Buffers.releaseDirectByteBuffer(buffer);
    }

    protected abstract void onReserveBuffer(long var1, int var3) throws IOException;

    public static void writeElement(final XmlWriter writer, String element, final Consumer<XmlWriter> consumer) throws IOException {
        new StringWriterTemplate(){

            @Override
            protected void onReserveBuffer(long addr, int length) throws IOException {
                writer.writeStart(addr, length);
                consumer.accept(writer);
                writer.writeEnd(addr, length);
            }
        }.reserveBuffer(element);
    }

    public static void writeAttribute(final XmlWriter writer, String attributeName, final char[] attributeValue) throws IOException {
        new StringWriterTemplate(){

            @Override
            protected void onReserveBuffer(long addr, int length) throws IOException {
                writer.writeAttribute(addr, length, attributeValue);
            }
        }.reserveBuffer(attributeName);
    }
}

