/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.util;

import io.legaldocml.unsafe.UnsafeHelper;
import io.legaldocml.util.HashReader;
import sun.misc.Unsafe;

final class XXHash {
    private static final Unsafe UNSAFE = UnsafeHelper.getUnsafe();
    private static final long PRIME64_1 = -7046029288634856825L;
    private static final long PRIME64_2 = -4417276706812531889L;
    private static final long PRIME64_3 = 1609587929392839161L;
    private static final long PRIME64_4 = -8796714831421723037L;
    private static final long PRIME64_5 = 2870177450012600261L;

    XXHash() {
    }

    public long xxHash64(long seed, long adr, long len, Object o) {
        long h64 = 0L;
        if (len >= 32L) {
            long p = len;
            long v1 = seed + -7046029288634856825L + -4417276706812531889L;
            long v2 = seed + -4417276706812531889L;
            long v3 = seed;
            long v4 = seed - -7046029288634856825L;
            do {
                v1 = XXHash.rotateLeft31(v1 + UNSAFE.getLong(o, adr) * -4417276706812531889L) * -7046029288634856825L;
                v2 = XXHash.rotateLeft31(v2 + UNSAFE.getLong(o, adr + 8L) * -4417276706812531889L) * -7046029288634856825L;
                v3 = XXHash.rotateLeft31(v3 + UNSAFE.getLong(o, adr + 16L) * -4417276706812531889L) * -7046029288634856825L;
                v4 = XXHash.rotateLeft31(v4 + UNSAFE.getLong(o, adr + 24L) * -4417276706812531889L) * -7046029288634856825L;
                adr += 32L;
            } while ((p -= 32L) >= 32L);
            h64 = XXHash.compute(h64, v1, v2, v3, v4) + len;
            len = p;
        } else {
            h64 = seed + 2870177450012600261L;
            h64 += len;
        }
        while (len >= 8L) {
            h64 = XXHash.rotateLeft(h64 ^ XXHash.rotateLeft31(UNSAFE.getLong(o, adr) * -4417276706812531889L) * -7046029288634856825L, 27) * -7046029288634856825L + -8796714831421723037L;
            len -= 8L;
            adr += 8L;
        }
        if (len >= 4L) {
            h64 = XXHash.rotateLeft(h64 ^ (long)UNSAFE.getInt(o, adr) * -7046029288634856825L, 23) * -4417276706812531889L + 1609587929392839161L;
            len -= 4L;
            adr += 4L;
        }
        while (len != 0L) {
            h64 = XXHash.rotateLeft(h64 ^ (long)UNSAFE.getByte(o, adr++) * 2870177450012600261L, 11) * -7046029288634856825L;
            --len;
        }
        h64 = (h64 ^ h64 >>> 33) * -4417276706812531889L;
        h64 = (h64 ^ h64 >>> 29) * 1609587929392839161L;
        return h64 ^ h64 >>> 32;
    }

    public long xxHash64(long seed, HashReader reader) {
        long h64 = 0L;
        long len = reader.length();
        if (len >= 32L) {
            long p = len;
            long v1 = seed + -7046029288634856825L + -4417276706812531889L;
            long v2 = seed + -4417276706812531889L;
            long v3 = seed;
            long v4 = seed - -7046029288634856825L;
            do {
                v1 = XXHash.rotateLeft31(v1 + reader.getLong() * -4417276706812531889L) * -7046029288634856825L;
                v2 = XXHash.rotateLeft31(v2 + reader.getLong() * -4417276706812531889L) * -7046029288634856825L;
                v3 = XXHash.rotateLeft31(v3 + reader.getLong() * -4417276706812531889L) * -7046029288634856825L;
                v4 = XXHash.rotateLeft31(v4 + reader.getLong() * -4417276706812531889L) * -7046029288634856825L;
            } while ((p -= 32L) >= 32L);
            h64 = XXHash.compute(h64, v1, v2, v3, v4) + len;
            len = p;
        } else {
            h64 = seed + 2870177450012600261L;
            h64 += len;
        }
        while (len >= 8L) {
            h64 = XXHash.rotateLeft(h64 ^ XXHash.rotateLeft(reader.getLong() * -4417276706812531889L, 31) * -7046029288634856825L, 27) * -7046029288634856825L + -8796714831421723037L;
            len -= 8L;
        }
        if (len >= 4L) {
            h64 = XXHash.rotateLeft(h64 ^ (long)reader.getInt() * -7046029288634856825L, 23) * -4417276706812531889L + 1609587929392839161L;
            len -= 4L;
        }
        while (len != 0L) {
            h64 = XXHash.rotateLeft(h64 ^ reader.getByte() * 2870177450012600261L, 11) * -7046029288634856825L;
            --len;
        }
        h64 = (h64 ^ h64 >>> 33) * -4417276706812531889L;
        h64 = (h64 ^ h64 >>> 29) * 1609587929392839161L;
        return h64 ^ h64 >>> 32;
    }

    private static long compute(long h64, long v1, long v2, long v3, long v4) {
        h64 = XXHash.rotateLeft(v1, 1) + XXHash.rotateLeft(v2, 7) + XXHash.rotateLeft(v3, 12) + XXHash.rotateLeft(v4, 18);
        h64 = (h64 ^ XXHash.rotateLeft31(v1 * -4417276706812531889L) * -7046029288634856825L) * -7046029288634856825L + -8796714831421723037L;
        h64 = (h64 ^ XXHash.rotateLeft31(v2 * -4417276706812531889L) * -7046029288634856825L) * -7046029288634856825L + -8796714831421723037L;
        h64 = (h64 ^ XXHash.rotateLeft31(v3 * -4417276706812531889L) * -7046029288634856825L) * -7046029288634856825L + -8796714831421723037L;
        h64 = (h64 ^ XXHash.rotateLeft31(v4 * -4417276706812531889L) * -7046029288634856825L) * -7046029288634856825L + -8796714831421723037L;
        return h64;
    }

    private static long rotateLeft(long i, int distance) {
        return i << distance | i >>> -distance;
    }

    private static long rotateLeft31(long i) {
        return i << 31 | i >>> -31;
    }
}

