/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.xpath.cerebro;

import com.google.common.collect.ImmutableMap;
import io.legaldocml.akn.AknObject;
import io.legaldocml.akn.AkomaNtoso;
import io.legaldocml.akn.AkomaNtosoType;
import io.legaldocml.akn.element.Act;
import io.legaldocml.akn.element.ActiveModifications;
import io.legaldocml.akn.element.Amendment;
import io.legaldocml.akn.element.AmendmentList;
import io.legaldocml.akn.element.Analysis;
import io.legaldocml.akn.element.Attachments;
import io.legaldocml.akn.element.Bill;
import io.legaldocml.akn.element.Body;
import io.legaldocml.akn.element.Classification;
import io.legaldocml.akn.element.Components;
import io.legaldocml.akn.element.Conclusions;
import io.legaldocml.akn.element.CoverPage;
import io.legaldocml.akn.element.Debate;
import io.legaldocml.akn.element.DebateBody;
import io.legaldocml.akn.element.DebateStructure;
import io.legaldocml.akn.element.HierarchicalStructure;
import io.legaldocml.akn.element.Identification;
import io.legaldocml.akn.element.Judicial;
import io.legaldocml.akn.element.Lifecycle;
import io.legaldocml.akn.element.Mappings;
import io.legaldocml.akn.element.Meta;
import io.legaldocml.akn.element.Notes;
import io.legaldocml.akn.element.OtherAnalysis;
import io.legaldocml.akn.element.OtherReferences;
import io.legaldocml.akn.element.Parliamentary;
import io.legaldocml.akn.element.ParliamentaryAnalysis;
import io.legaldocml.akn.element.ParliamentaryAnalysisElement;
import io.legaldocml.akn.element.PassiveModifications;
import io.legaldocml.akn.element.Preamble;
import io.legaldocml.akn.element.Preface;
import io.legaldocml.akn.element.Presentation;
import io.legaldocml.akn.element.Proprietary;
import io.legaldocml.akn.element.Publication;
import io.legaldocml.akn.element.QuorumVerification;
import io.legaldocml.akn.element.Recount;
import io.legaldocml.akn.element.References;
import io.legaldocml.akn.element.Restrictions;
import io.legaldocml.akn.element.Step;
import io.legaldocml.akn.element.TemporalData;
import io.legaldocml.akn.element.Voting;
import io.legaldocml.akn.element.Workflow;
import io.legaldocml.xpath.cerebro.CerebroDefinition;
import io.legaldocml.xpath.cerebro.CerebroDirectLink;
import io.legaldocml.xpath.cerebro.CerebroException;
import io.legaldocml.xpath.cerebro.CerebroLink;
import io.legaldocml.xpath.cerebro.CerebroListFilterLink;
import io.legaldocml.xpath.cerebro.CerebroListLink;

public class Cerebro {
    private static ImmutableMap<Class<? extends AknObject>, CerebroDefinition> DEFINITIONS;

    public static CerebroLink getLink(Class<? extends AknObject> parent, Class<? extends AknObject> child) {
        CerebroDefinition definition = (CerebroDefinition)DEFINITIONS.get(parent);
        if (definition == null) {
            throw new CerebroException("No defintion found for [" + parent + "] (child=" + child + ")");
        }
        return definition.getLink(child);
    }

    private static <T extends HierarchicalStructure> CerebroDefinition<T> hierarchicalStructure(Class<T> clazz) {
        return new CerebroDefinition(new CerebroDirectLink<HierarchicalStructure, Meta>(Meta.class, rec$ -> ((HierarchicalStructure)rec$).getMeta()), new CerebroDirectLink<HierarchicalStructure, CoverPage>(CoverPage.class, rec$ -> ((HierarchicalStructure)rec$).getCoverPage()), new CerebroDirectLink<HierarchicalStructure, Preface>(Preface.class, rec$ -> ((HierarchicalStructure)rec$).getPreface()), new CerebroDirectLink<HierarchicalStructure, Preamble>(Preamble.class, rec$ -> ((HierarchicalStructure)rec$).getPreamble()), new CerebroDirectLink<HierarchicalStructure, Body>(Body.class, HierarchicalStructure::getBody), new CerebroDirectLink<HierarchicalStructure, Conclusions>(Conclusions.class, rec$ -> ((HierarchicalStructure)rec$).getConclusions()), new CerebroDirectLink<HierarchicalStructure, Attachments>(Attachments.class, rec$ -> ((HierarchicalStructure)rec$).getAttachments()), new CerebroDirectLink<HierarchicalStructure, Components>(Components.class, rec$ -> ((HierarchicalStructure)rec$).getComponents()));
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(AkomaNtoso.class, new CerebroDefinition(new CerebroDirectLink<AkomaNtoso, Bill>(Bill.class, AkomaNtosoType::getDocumentType), new CerebroDirectLink<AkomaNtoso, AmendmentList>(AmendmentList.class, AkomaNtosoType::getDocumentType), new CerebroDirectLink<AkomaNtoso, Amendment>(Amendment.class, AkomaNtosoType::getDocumentType), new CerebroDirectLink<AkomaNtoso, Debate>(Debate.class, AkomaNtosoType::getDocumentType), new CerebroDirectLink<AkomaNtoso, Components>(Components.class, AkomaNtosoType::getComponents)));
        builder.put(Act.class, Cerebro.hierarchicalStructure(Act.class));
        builder.put(Bill.class, Cerebro.hierarchicalStructure(Bill.class));
        builder.put(Debate.class, new CerebroDefinition(new CerebroDirectLink<Debate, Meta>(Meta.class, rec$ -> ((Debate)rec$).getMeta()), new CerebroDirectLink<Debate, CoverPage>(CoverPage.class, rec$ -> ((Debate)rec$).getCoverPage()), new CerebroDirectLink<Debate, Preface>(Preface.class, rec$ -> ((Debate)rec$).getPreface()), new CerebroDirectLink<Debate, DebateBody>(DebateBody.class, DebateStructure::getDebateBody), new CerebroDirectLink<Debate, Conclusions>(Conclusions.class, rec$ -> ((Debate)rec$).getConclusions()), new CerebroDirectLink<Debate, Attachments>(Attachments.class, rec$ -> ((Debate)rec$).getAttachments()), new CerebroDirectLink<Debate, Components>(Components.class, rec$ -> ((Debate)rec$).getComponents())));
        builder.put(Meta.class, new CerebroDefinition(new CerebroDirectLink<Meta, Identification>(Identification.class, Meta::getIdentification), new CerebroDirectLink<Meta, Publication>(Publication.class, Meta::getPublication), new CerebroListLink<Meta, Classification>(Classification.class, Meta::getClassifications), new CerebroListLink<Meta, Lifecycle>(Lifecycle.class, Meta::getLifecycles), new CerebroListLink<Meta, Workflow>(Workflow.class, Meta::getWorkflows), new CerebroListLink<Meta, Analysis>(Analysis.class, Meta::getAnalysis), new CerebroListLink<Meta, TemporalData>(TemporalData.class, Meta::getTemporalData), new CerebroListLink<Meta, References>(References.class, Meta::getReferences), new CerebroListLink<Meta, Notes>(Notes.class, Meta::getNotes), new CerebroListLink<Meta, Proprietary>(Proprietary.class, Meta::getProprietaries), new CerebroListLink<Meta, Presentation>(Presentation.class, Meta::getPresentations)));
        builder.put(Workflow.class, new CerebroDefinition(new CerebroListLink<Workflow, Step>(Step.class, Workflow::getSteps)));
        builder.put(Analysis.class, new CerebroDefinition(new CerebroDirectLink<Analysis, ActiveModifications>(ActiveModifications.class, Analysis::getActiveModifications), new CerebroDirectLink<Analysis, PassiveModifications>(PassiveModifications.class, Analysis::getPassiveModifications), new CerebroDirectLink<Analysis, Restrictions>(Restrictions.class, Analysis::getRestrictions), new CerebroDirectLink<Analysis, Judicial>(Judicial.class, Analysis::getJudicial), new CerebroDirectLink<Analysis, Parliamentary>(Parliamentary.class, Analysis::getParliamentary), new CerebroDirectLink<Analysis, Mappings>(Mappings.class, Analysis::getMappings), new CerebroListLink<Analysis, OtherReferences>(OtherReferences.class, Analysis::getOtherReferences), new CerebroListLink<Analysis, OtherAnalysis>(OtherAnalysis.class, Analysis::getOtherAnalysis)));
        builder.put(Parliamentary.class, new CerebroDefinition(new CerebroListLink<Parliamentary, ParliamentaryAnalysisElement>(ParliamentaryAnalysisElement.class, ParliamentaryAnalysis::getElements), new CerebroListFilterLink<Parliamentary, ParliamentaryAnalysisElement, Voting>(ParliamentaryAnalysisElement.class, Voting.class, ParliamentaryAnalysis::getElements), new CerebroListFilterLink<Parliamentary, ParliamentaryAnalysisElement, QuorumVerification>(ParliamentaryAnalysisElement.class, QuorumVerification.class, ParliamentaryAnalysis::getElements), new CerebroListFilterLink<Parliamentary, ParliamentaryAnalysisElement, Recount>(ParliamentaryAnalysisElement.class, Recount.class, ParliamentaryAnalysis::getElements)));
        DEFINITIONS = builder.build();
    }
}

