/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.xpath.cerebro;

import com.google.common.collect.ImmutableMap;
import io.legaldocml.akn.AknObject;
import io.legaldocml.xpath.cerebro.CerebroLink;

public final class CerebroDefinition<T extends AknObject> {
    private final ImmutableMap<Class<? extends AknObject>, CerebroLink> links;

    public CerebroDefinition(CerebroLink ... cerebroLinks) {
        this((CerebroDefinition)null, cerebroLinks);
    }

    public CerebroDefinition(CerebroDefinition parent, CerebroLink ... cerebroLinks) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (parent != null) {
            builder.putAll(parent.links);
        }
        for (CerebroLink link : cerebroLinks) {
            builder.put(link.getAknClass(), (Object)link);
        }
        this.links = builder.build();
    }

    public CerebroLink getLink(Class<? extends AknObject> child) {
        return (CerebroLink)this.links.get(child);
    }
}

