/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.xpath.cerebro;

import io.legaldocml.akn.AknObject;
import io.legaldocml.xpath.cerebro.CerebroLink;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class CerebroListLink<T extends AknObject, E extends AknObject>
implements CerebroLink<T> {
    private final Class<E> aknClass;
    private final Function<T, Stream<E>> link;

    public CerebroListLink(Class<E> aknClass, Function<T, Stream<E>> link) {
        this.aknClass = aknClass;
        this.link = link;
    }

    @Override
    public Class<E> getAknClass() {
        return this.aknClass;
    }

    @Override
    public Object apply(T t) {
        List list = t instanceof List ? ((List)t).stream().map(this.link).collect(Collectors.toList()) : this.link.apply(t).collect(Collectors.toList());
        if (list != null && list.size() == 1) {
            return list.get(0);
        }
        return list;
    }
}

