/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.xpath.impl;

import io.legaldocml.akn.AknObject;
import io.legaldocml.module.Module;
import io.legaldocml.xpath.XPath;
import io.legaldocml.xpath.cerebro.Cerebro;
import io.legaldocml.xpath.eval.StepEval;
import io.legaldocml.xpath.impl.QueryBuilder;
import io.legaldocml.xpath.impl.QueryPredicateBuilder;
import io.legaldocml.xpath.impl.XPathQname;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AbsoluteQueryBuilder
extends QueryBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbsoluteQueryBuilder.class);
    private final List<StepEval> stetps = new ArrayList<StepEval>();
    private Class<? extends AknObject> parent;

    protected AbsoluteQueryBuilder(XPath xPath) {
        super(xPath);
    }

    @Override
    public void append(XPathQname qname) {
        Module module = this.getXPath().getModule(qname.getPrefix());
        Class aknClass = module.getAknClass(qname.getLocalname());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("append({}) -> [{}]", (Object)qname, (Object)aknClass);
        }
        if (this.parent == null) {
            this.parent = aknClass;
            return;
        }
        this.stetps.add(new StepEval(Cerebro.getLink(this.parent, aknClass)));
        this.parent = aknClass;
    }

    @Override
    public void append(QueryPredicateBuilder queryPredicateBuilder) {
        StepEval last = this.stetps.get(this.stetps.size() - 1);
        queryPredicateBuilder.buildOn(last);
    }

    @Override
    List<StepEval> getSteps() {
        return this.stetps;
    }
}

