/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.xpath.impl;

import io.legaldocml.xpath.XPath2Parser;
import io.legaldocml.xpath.XPath2ParserBaseListener;
import io.legaldocml.xpath.XPathException;
import io.legaldocml.xpath.XPathExpression;
import io.legaldocml.xpath.impl.QueryBuilder;
import io.legaldocml.xpath.impl.QueryPredicateBuilder;
import io.legaldocml.xpath.impl.XPathExpressionImpl;
import io.legaldocml.xpath.impl.XPathImpl;
import io.legaldocml.xpath.impl.XPathQnameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class XPathExpressionBuilder
extends XPath2ParserBaseListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(XPathExpressionBuilder.class);
    private final XPathQnameBuilder qnameBuilder = new XPathQnameBuilder();
    private QueryBuilder queryBuilder;
    private QueryPredicateBuilder queryPredicateBuilder;
    private final XPathImpl xpath;
    private final XPath2Parser parser;
    private boolean predicate = false;

    public XPathExpressionBuilder(XPathImpl xpath, XPath2Parser parser) {
        this.xpath = xpath;
        this.parser = parser;
    }

    @Override
    public void exitIntegerLiteral(XPath2Parser.IntegerLiteralContext ctx) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("exitIntegerLiteral [{}]", (Object)ctx.getText());
        }
        if (this.predicate) {
            this.queryPredicateBuilder.append(Integer.valueOf(ctx.getText()));
            return;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void enterPredicate(XPath2Parser.PredicateContext ctx) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("enterPredicate [{}]", (Object)this.predicate);
        }
        this.predicate = true;
        this.queryPredicateBuilder = new QueryPredicateBuilder();
    }

    @Override
    public void exitPredicate(XPath2Parser.PredicateContext ctx) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("exitPredicate [{}] -> [{}]", (Object)this.predicate, (Object)ctx.expr().getText());
        }
        this.predicate = false;
        this.queryBuilder.append(this.queryPredicateBuilder);
        this.queryPredicateBuilder = null;
    }

    @Override
    public void enterPathExpr(XPath2Parser.PathExprContext ctx) {
        if (21 == ctx.start.getType()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("absolute path");
            }
            this.queryBuilder = QueryBuilder.absolute(this.xpath);
            return;
        }
        if (this.predicate) {
            return;
        }
        throw new UnsupportedOperationException("" + ctx.start.getType());
    }

    @Override
    public void exitQName(XPath2Parser.QNameContext ctx) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("qname [{}]", (Object)ctx.getText());
        }
        try {
            this.queryBuilder.append(this.qnameBuilder.build());
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
        this.qnameBuilder.reset();
    }

    @Override
    public void exitNCName(XPath2Parser.NCNameContext ctx) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("NCName [{}]", (Object)ctx.getText());
        }
        this.qnameBuilder.append(ctx.getText());
    }

    public XPathExpression build() {
        return new XPathExpressionImpl(this.queryBuilder.getSteps());
    }
}

