/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.xpath.impl;

import io.legaldocml.akn.AkomaNtoso;
import io.legaldocml.akn.DocumentType;
import io.legaldocml.xpath.XPathExpression;
import io.legaldocml.xpath.eval.StepEval;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class XPathExpressionImpl
implements XPathExpression {
    private static final Logger LOGGER = LoggerFactory.getLogger(XPathExpressionImpl.class);
    private final List<StepEval> steps;

    XPathExpressionImpl(List<StepEval> steps) {
        this.steps = steps;
    }

    @Override
    public <T extends DocumentType> Optional<Object> evaluate(AkomaNtoso<T> akomaNtoso) {
        List<StepEval> evals = this.steps;
        Object result = akomaNtoso;
        for (int i = 0; i < evals.size(); ++i) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("In  -> [{}] -> [{}] -> [{}]", new Object[]{i, result, this.steps.get(i)});
            }
            if ((result = evals.get(i).eval(result)) != null) continue;
            return Optional.empty();
        }
        return Optional.of(result);
    }
}

