/*
 * Decompiled with CFR 0.152.
 */
package io.legere.pdfiumandroid;

import android.graphics.RectF;
import io.legere.pdfiumandroid.Logger;
import io.legere.pdfiumandroid.PdfDocument;
import io.legere.pdfiumandroid.PdfiumCore;
import io.legere.pdfiumandroid.util.ConfigKt;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u000b\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\f\n\u0002\b\u0002\u0018\u0000 F2\u00020\u0001:\u0001FB1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005J\u0011\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0007H\u0082 J\u0019\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0005H\u0082 J\u0011\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0007H\u0082 J!\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005H\u0082 J9\u0010\"\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(H\u0082 J\u0019\u0010)\u001a\u00020*2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u0005H\u0082 J1\u0010,\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u00192\u0006\u00100\u001a\u00020\u0019H\u0082 J\u0019\u00101\u001a\u00020*2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u0005H\u0082 J)\u00103\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\u0006\u00104\u001a\u00020(H\u0082 J)\u00105\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\u0006\u00104\u001a\u000206H\u0082 J\u0019\u00107\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u0005H\u0082 J\u0006\u00108\u001a\u00020\u0005J\u0016\u00109\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005J\u0018\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u0005J\u0010\u0010?\u001a\u0004\u0018\u00010=2\u0006\u0010+\u001a\u00020\u0005J&\u0010@\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u00192\u0006\u00100\u001a\u00020\u0019J\u0010\u0010A\u001a\u0004\u0018\u00010=2\u0006\u00102\u001a\u00020\u0005J\u0018\u0010B\u001a\u0004\u0018\u00010;2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010>\u001a\u00020\u0005J\u0018\u0010C\u001a\u0004\u0018\u00010;2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010>\u001a\u00020\u0005J\u000e\u0010D\u001a\u00020E2\u0006\u0010+\u001a\u00020\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006G"}, d2={"Lio/legere/pdfiumandroid/PdfTextPage;", "Ljava/io/Closeable;", "doc", "Lio/legere/pdfiumandroid/PdfDocument;", "pageIndex", "", "pagePtr", "", "pageMap", "", "Lio/legere/pdfiumandroid/PdfDocument$PageCount;", "(Lio/legere/pdfiumandroid/PdfDocument;IJLjava/util/Map;)V", "getDoc", "()Lio/legere/pdfiumandroid/PdfDocument;", "isClosed", "", "getPageIndex", "()I", "getPageMap", "()Ljava/util/Map;", "getPagePtr", "()J", "close", "", "getFontSize", "", "charIndex", "nativeCloseTextPage", "nativeGetFontSize", "nativeTextCountChars", "textPagePtr", "nativeTextCountRects", "startIndex", "count", "nativeTextGetBoundedText", "left", "top", "right", "bottom", "arr", "", "nativeTextGetCharBox", "", "index", "nativeTextGetCharIndexAtPos", "x", "y", "xTolerance", "yTolerance", "nativeTextGetRect", "rectIndex", "nativeTextGetText", "result", "nativeTextGetTextByteArray", "", "nativeTextGetUnicode", "textPageCountChars", "textPageCountRects", "textPageGetBoundedText", "", "rect", "Landroid/graphics/RectF;", "length", "textPageGetCharBox", "textPageGetCharIndexAtPos", "textPageGetRect", "textPageGetText", "textPageGetTextLegacy", "textPageGetUnicode", "", "Companion", "pdfiumandroid_release"})
@SourceDebugExtension(value={"SMAP\nPdfTextPage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PdfTextPage.kt\nio/legere/pdfiumandroid/PdfTextPage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,370:1\n1#2:371\n*E\n"})
public final class PdfTextPage
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PdfDocument doc;
    private final int pageIndex;
    private final long pagePtr;
    @NotNull
    private final Map<Integer, PdfDocument.PageCount> pageMap;
    private boolean isClosed;
    private static final String TAG = PdfTextPage.class.getName();

    public PdfTextPage(@NotNull PdfDocument doc, int pageIndex, long pagePtr, @NotNull Map<Integer, PdfDocument.PageCount> pageMap) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter(pageMap, (String)"pageMap");
        this.doc = doc;
        this.pageIndex = pageIndex;
        this.pagePtr = pagePtr;
        this.pageMap = pageMap;
    }

    @NotNull
    public final PdfDocument getDoc() {
        return this.doc;
    }

    public final int getPageIndex() {
        return this.pageIndex;
    }

    public final long getPagePtr() {
        return this.pagePtr;
    }

    @NotNull
    public final Map<Integer, PdfDocument.PageCount> getPageMap() {
        return this.pageMap;
    }

    private final native void nativeCloseTextPage(long var1);

    private final native int nativeTextCountChars(long var1);

    private final native int nativeTextGetText(long var1, int var3, int var4, short[] var5);

    private final native int nativeTextGetTextByteArray(long var1, int var3, int var4, byte[] var5);

    private final native int nativeTextGetUnicode(long var1, int var3);

    private final native double[] nativeTextGetCharBox(long var1, int var3);

    private final native int nativeTextGetCharIndexAtPos(long var1, double var3, double var5, double var7, double var9);

    private final native int nativeTextCountRects(long var1, int var3, int var4);

    private final native double[] nativeTextGetRect(long var1, int var3);

    private final native double nativeGetFontSize(long var1, int var3);

    private final native int nativeTextGetBoundedText(long var1, double var3, double var5, double var7, double var9, short[] var11);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int textPageCountChars() {
        if (ConfigKt.handleAlreadyClosed(this.isClosed || this.doc.isClosed())) {
            return -1;
        }
        Object object = PdfiumCore.Companion.getLock();
        synchronized (object) {
            boolean bl = false;
            int n = this.nativeTextCountChars(this.pagePtr);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final String textPageGetTextLegacy(int startIndex, int length) {
        if (ConfigKt.handleAlreadyClosed(this.isClosed || this.doc.isClosed())) {
            return null;
        }
        Object object = PdfiumCore.Companion.getLock();
        synchronized (object) {
            boolean bl = false;
            try {
                short[] buf = new short[length + 1];
                int r = this.nativeTextGetText(this.pagePtr, startIndex, length, buf);
                if (r <= 0) {
                    return "";
                }
                byte[] bytes = new byte[(r - 1) * 2];
                ByteBuffer bb = ByteBuffer.wrap(bytes);
                bb.order(ByteOrder.LITTLE_ENDIAN);
                int i = 0;
                int n = r - 1;
                while (true) {
                    if (i >= n) {
                        Charset charset = StandardCharsets.UTF_16LE;
                        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_16LE");
                        Charset charset2 = charset;
                        return new String(bytes, charset2);
                    }
                    short s = buf[i];
                    bb.putShort(s);
                    ++i;
                }
            }
            catch (NullPointerException e) {
                String string = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                Logger.INSTANCE.e(string, e, "mContext may be null");
                return null;
            }
            catch (Exception e) {
                String string = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                Logger.INSTANCE.e(string, e, "Exception throw from native");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final String textPageGetText(int startIndex, int length) {
        if (ConfigKt.handleAlreadyClosed(this.isClosed || this.doc.isClosed())) {
            return null;
        }
        Object object = PdfiumCore.Companion.getLock();
        synchronized (object) {
            boolean bl = false;
            try {
                byte[] bytes = new byte[length * 2];
                int r = this.nativeTextGetTextByteArray(this.pagePtr, startIndex, length, bytes);
                if (r <= 0) {
                    return "";
                }
                Charset charset = StandardCharsets.UTF_16LE;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_16LE");
                Charset charset2 = charset;
                return new String(bytes, charset2);
            }
            catch (NullPointerException e) {
                String string = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                Logger.INSTANCE.e(string, e, "mContext may be null");
                return null;
            }
            catch (Exception e) {
                String string = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                Logger.INSTANCE.e(string, e, "Exception throw from native");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final char textPageGetUnicode(int index) {
        if (!(!this.isClosed && !this.doc.isClosed())) {
            boolean bl = false;
            String string = "Already closed";
            throw new IllegalStateException(string.toString());
        }
        Object object = PdfiumCore.Companion.getLock();
        synchronized (object) {
            boolean bl = false;
            char c = (char)this.nativeTextGetUnicode(this.pagePtr, index);
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final RectF textPageGetCharBox(int index) {
        if (ConfigKt.handleAlreadyClosed(this.isClosed || this.doc.isClosed())) {
            return null;
        }
        Object object = PdfiumCore.Companion.getLock();
        synchronized (object) {
            boolean bl = false;
            try {
                double[] o = this.nativeTextGetCharBox(this.pagePtr, index);
                RectF r = new RectF();
                r.left = (float)o[0];
                r.right = (float)o[1];
                r.bottom = (float)o[2];
                r.top = (float)o[3];
                return r;
            }
            catch (NullPointerException e) {
                String string = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                Logger.INSTANCE.e(string, e, "mContext may be null");
            }
            catch (Exception e) {
                String string = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                Logger.INSTANCE.e(string, e, "Exception throw from native");
            }
            Unit unit = Unit.INSTANCE;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int textPageGetCharIndexAtPos(double x, double y, double xTolerance, double yTolerance) {
        if (ConfigKt.handleAlreadyClosed(this.isClosed || this.doc.isClosed())) {
            return -1;
        }
        Object object = PdfiumCore.Companion.getLock();
        synchronized (object) {
            boolean bl = false;
            try {
                int n = this.nativeTextGetCharIndexAtPos(this.pagePtr, x, y, xTolerance, yTolerance);
                return n;
            }
            catch (Exception e) {
                String string = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                Logger.INSTANCE.e(string, e, "Exception throw from native");
                Unit unit = Unit.INSTANCE;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int textPageCountRects(int startIndex, int count) {
        if (!(!this.isClosed && !this.doc.isClosed())) {
            boolean bl = false;
            String string = "Already closed";
            throw new IllegalStateException(string.toString());
        }
        Object object = PdfiumCore.Companion.getLock();
        synchronized (object) {
            boolean bl = false;
            try {
                return this.nativeTextCountRects(this.pagePtr, startIndex, count);
            }
            catch (NullPointerException e) {
                String string = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                Logger.INSTANCE.e(string, e, "mContext may be null");
            }
            catch (Exception e) {
                String string = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                Logger.INSTANCE.e(string, e, "Exception throw from native");
            }
            Unit unit = Unit.INSTANCE;
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final RectF textPageGetRect(int rectIndex) {
        if (ConfigKt.handleAlreadyClosed(this.isClosed || this.doc.isClosed())) {
            return null;
        }
        Object object = PdfiumCore.Companion.getLock();
        synchronized (object) {
            RectF rectF;
            boolean bl = false;
            try {
                double[] o = this.nativeTextGetRect(this.pagePtr, rectIndex);
                RectF r = new RectF();
                r.left = (float)o[0];
                r.top = (float)o[1];
                r.right = (float)o[2];
                r.bottom = (float)o[3];
                rectF = r;
            }
            catch (NullPointerException e) {
                String string = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                Logger.INSTANCE.e(string, e, "mContext may be null");
                rectF = null;
            }
            catch (Exception e) {
                String string = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                Logger.INSTANCE.e(string, e, "Exception throw from native");
                rectF = null;
            }
            RectF rectF2 = rectF;
            return rectF2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String textPageGetBoundedText(@NotNull RectF rect, int length) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        if (ConfigKt.handleAlreadyClosed(this.isClosed || this.doc.isClosed())) {
            return null;
        }
        Object object = PdfiumCore.Companion.getLock();
        synchronized (object) {
            String string;
            boolean bl = false;
            try {
                short[] buf = new short[length + 1];
                int r = this.nativeTextGetBoundedText(this.pagePtr, rect.left, rect.top, rect.right, rect.bottom, buf);
                byte[] bytes = new byte[(r - 1) * 2];
                ByteBuffer bb = ByteBuffer.wrap(bytes);
                bb.order(ByteOrder.LITTLE_ENDIAN);
                int n = r - 1;
                for (int i = 0; i < n; ++i) {
                    short s = buf[i];
                    bb.putShort(s);
                }
                Charset charset = StandardCharsets.UTF_16LE;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_16LE");
                Charset charset2 = charset;
                string = new String(bytes, charset2);
            }
            catch (NullPointerException e) {
                String string2 = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
                Logger.INSTANCE.e(string2, e, "mContext may be null");
                string = null;
            }
            catch (Exception e) {
                String string3 = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"TAG");
                Logger.INSTANCE.e(string3, e, "Exception throw from native");
                string = null;
            }
            String string4 = string;
            return string4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double getFontSize(int charIndex) {
        if (ConfigKt.handleAlreadyClosed(this.isClosed || this.doc.isClosed())) {
            return 0.0;
        }
        Object object = PdfiumCore.Companion.getLock();
        synchronized (object) {
            boolean bl = false;
            double d = this.nativeGetFontSize(this.pagePtr, charIndex);
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (ConfigKt.handleAlreadyClosed(this.isClosed || this.doc.isClosed())) {
            return;
        }
        Object object = PdfiumCore.Companion.getLock();
        synchronized (object) {
            boolean bl = false;
            PdfDocument.PageCount pageCount = this.pageMap.get(this.pageIndex);
            if (pageCount != null) {
                PdfDocument.PageCount it = pageCount;
                boolean bl2 = false;
                if (it.getCount() > 1) {
                    int n = it.getCount();
                    it.setCount(n + -1);
                    return;
                }
            }
            this.pageMap.remove(this.pageIndex);
            this.isClosed = true;
            this.nativeCloseTextPage(this.pagePtr);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/legere/pdfiumandroid/PdfTextPage$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "pdfiumandroid_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

