package io.lemoncloud.core.architecture.data

import kotlinx.coroutines.flow.combine

/**
 * Result 타입의 Flow를 핸들링 하기 위한 익스텐션
 */

object ResultFlowExtensions {
    fun <T1, T2, R> combineResultFlow(
        flow1: ResultFlow<T1>,
        flow2: ResultFlow<T2>,
        onSuccess: (T1, T2) -> R,
        onFailure: (Throwable) -> Throwable,
    ): ResultFlow<R> =
        ResultFlow(
            combine(flow1.value, flow2.value) { result1, result2 ->
                result1.fold(
                    onSuccess = { value1 ->
                        result2.fold(
                            onSuccess = { value2 -> runCatching { onSuccess(value1, value2) } },
                            onFailure = { exception -> Result.failure(onFailure(exception)) },
                        )
                    },
                    onFailure = { exception -> Result.failure(onFailure(exception)) },
                )
            },
        )

    fun <T1, T2, T3, R> combineResultFlow(
        flow1: ResultFlow<T1>,
        flow2: ResultFlow<T2>,
        flow3: ResultFlow<T3>,
        onSuccess: (T1, T2, T3) -> R,
        onFailure: (Throwable) -> Throwable,
    ): ResultFlow<R> =
        ResultFlow(
            combine(flow1.value, flow2.value, flow3.value) { result1, result2, result3 ->
                result1.fold(
                    onSuccess = { value1 ->
                        result2.fold(
                            onSuccess = { value2 ->
                                result3.fold(
                                    onSuccess = { value3 ->
                                        runCatching { onSuccess(value1, value2, value3) }
                                    },
                                    onFailure = { exception -> Result.failure(onFailure(exception)) },
                                )
                            },
                            onFailure = { exception -> Result.failure(onFailure(exception)) },
                        )
                    },
                    onFailure = { exception -> Result.failure(onFailure(exception)) },
                )
            },
        )

    fun <T1, T2, T3, R> combineResultFlow(
        flow1: ResultFlow<T1>,
        flow2: ResultFlow<T2>,
        flow3: ResultFlow<T3>,
        transform: (T1, T2, T3) -> R,
    ): ResultFlow<R> =
        ResultFlow(
            combine(flow1.value, flow2.value, flow3.value) { result1, result2, result3 ->
                result1.fold(
                    onSuccess = { value1 ->
                        result2.fold(
                            onSuccess = { value2 ->
                                result3.fold(
                                    onSuccess = { value3 ->
                                        runCatching { transform(value1, value2, value3) }
                                    },
                                    onFailure = { exception -> Result.failure(exception) },
                                )
                            },
                            onFailure = { exception -> Result.failure(exception) },
                        )
                    },
                    onFailure = { exception -> Result.failure(exception) },
                )
            },
        )

    fun <T1, T2, T3, T4, R> combineResultFlow(
        flow1: ResultFlow<T1>,
        flow2: ResultFlow<T2>,
        flow3: ResultFlow<T3>,
        flow4: ResultFlow<T4>,
        transform: (T1, T2, T3, T4) -> R,
    ): ResultFlow<R> =
        ResultFlow(
            combine(flow1.value, flow2.value, flow3.value, flow4.value) { result1, result2, result3, result4 ->
                result1.fold(
                    onSuccess = { value1 ->
                        result2.fold(
                            onSuccess = { value2 ->
                                result3.fold(
                                    onSuccess = { value3 ->
                                        result4.fold(
                                            onSuccess = { value4 ->
                                                runCatching { transform(value1, value2, value3, value4) }
                                            },
                                            onFailure = { exception -> Result.failure(exception) },
                                        )
                                    },
                                    onFailure = { exception -> Result.failure(exception) },
                                )
                            },
                            onFailure = { exception -> Result.failure(exception) },
                        )
                    },
                    onFailure = { exception -> Result.failure(exception) },
                )
            },
        )
}
