/*
 * Copyright 2017-2019 Lenses.io Ltd
 */
package io.lenses.audits.plugin.scalaapi

import io.lenses.audits.plugin.javaapi.{AuditPlugin => JAuditPlugin}
import io.lenses.audits.plugin.scalaapi.util.TryUtils._

import scala.util.Try
import scala.collection.JavaConverters._

/**
  * simple Audit plugin wrapper
  */
class AuditPlugin(underlying: JAuditPlugin) {

  def init(config: Map[String, String]): Try[AuditService] = for {
    init    <- Try { underlying.init(config.asJava) }
    service <- init.asScala
  } yield new AuditService(service)
}

object AuditPlugin {
  def apply(underlying: JAuditPlugin): AuditPlugin = new AuditPlugin(underlying)
}