package io.lenses.jdbc4.statements

import java.sql.SQLFeatureNotSupportedException
import java.sql.Statement

// extends statement implementing methods that are not supported by read only statements
interface ReadOnlyStatement : Statement {

  override fun execute(sql: String?,
                       autoGeneratedKeys: Int): Boolean = throw SQLFeatureNotSupportedException("Auto generated keys are not supported by Lenses")

  override fun execute(sql: String?,
                       columnIndexes: IntArray?): Boolean = throw SQLFeatureNotSupportedException("Auto generated keys are not supported by Lenses")

  override fun execute(sql: String?,
                       columnNames: Array<out String>?): Boolean = throw SQLFeatureNotSupportedException("Auto generated keys are not supported by Lenses")

  override fun addBatch(sql: String?) = throw SQLFeatureNotSupportedException()
  override fun executeUpdate(sql: String?, autoGeneratedKeys: Int): Int = throw SQLFeatureNotSupportedException()
  override fun executeUpdate(sql: String?, columnIndexes: IntArray?): Int = throw SQLFeatureNotSupportedException()
  override fun executeUpdate(sql: String?,
                             columnNames: Array<out String>?): Int = throw SQLFeatureNotSupportedException()

  override fun getUpdateCount(): Int = -1

  override fun clearBatch() = unsupported()
  override fun executeBatch(): IntArray = unsupported()
}