/*
 * Decompiled with CFR 0.152.
 */
package io.lenses.jdbc4;

import io.lenses.jdbc4.AvroExtensionsKt;
import io.lenses.jdbc4.AvroSchemas$WhenMappings;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\f"}, d2={"Lio/lenses/jdbc4/AvroSchemas;", "", "()V", "jvmClassName", "", "type", "Lorg/apache/avro/Schema$Type;", "normalizedName", "schema", "Lorg/apache/avro/Schema;", "sqlType", "", "lenses-jdbc"})
public final class AvroSchemas {
    public static final AvroSchemas INSTANCE;

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final String normalizedName(@NotNull Schema schema) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Schema.Type type = schema.getType();
        if (type != null) {
            switch (AvroSchemas$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    string = AvroExtensionsKt.fromUnion(schema).getType().name();
                    return string;
                }
            }
        }
        string = schema.getType().name();
        return string;
    }

    @NotNull
    public final String jvmClassName(@NotNull Schema.Type type) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        switch (AvroSchemas$WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1: {
                String string2 = Boolean.class.getCanonicalName();
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.Boolean::class.java.canonicalName");
                break;
            }
            case 2: {
                String string3 = new byte[]{1}.getClass().getCanonicalName();
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"byteArrayOf(1)::class.java.canonicalName");
                break;
            }
            case 3: {
                String string4 = String.class.getCanonicalName();
                string = string4;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String::class.java.canonicalName");
                break;
            }
            case 4: {
                String string5 = Double.class.getCanonicalName();
                string = string5;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.Double::class.java.canonicalName");
                break;
            }
            case 5: {
                String string6 = Float.class.getCanonicalName();
                string = string6;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"java.lang.Float::class.java.canonicalName");
                break;
            }
            case 6: {
                String string7 = Integer.class.getCanonicalName();
                string = string7;
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"java.lang.Integer::class.java.canonicalName");
                break;
            }
            case 7: {
                String string8 = Long.class.getCanonicalName();
                string = string8;
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"java.lang.Long::class.java.canonicalName");
                break;
            }
            case 8: {
                String string9 = String.class.getCanonicalName();
                string = string9;
                Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"java.lang.String::class.java.canonicalName");
                break;
            }
            default: {
                throw (Throwable)new SQLException("Unknown class name for " + type);
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int sqlType(@NotNull Schema schema) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Schema.Type type = schema.getType();
        if (type == null) throw (Throwable)new SQLFeatureNotSupportedException();
        switch (AvroSchemas$WhenMappings.$EnumSwitchMapping$2[type.ordinal()]) {
            case 1: {
                return 2003;
            }
            case 2: {
                return 16;
            }
            case 3: {
                LogicalType logicalType = schema.getLogicalType();
                if (logicalType == null) {
                    return -2;
                }
                if (logicalType instanceof LogicalTypes.Decimal) {
                    return 3;
                }
                LogicalType logicalType2 = schema.getLogicalType();
                Intrinsics.checkExpressionValueIsNotNull((Object)logicalType2, (String)"schema.logicalType");
                if (!Intrinsics.areEqual((Object)logicalType2.getName(), (Object)"uuid")) return -2;
                return 12;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 12;
            }
            case 6: {
                return -2;
            }
            case 7: {
                return 6;
            }
            case 8: {
                LogicalType logicalType = schema.getLogicalType();
                if (logicalType instanceof LogicalTypes.TimeMillis) {
                    return 92;
                }
                if (!(logicalType instanceof LogicalTypes.Date)) return 4;
                return 91;
            }
            case 9: {
                LogicalType logicalType = schema.getLogicalType();
                if (logicalType instanceof LogicalTypes.TimestampMillis) {
                    return 93;
                }
                if (logicalType instanceof LogicalTypes.TimestampMicros) {
                    return 93;
                }
                if (!(logicalType instanceof LogicalTypes.TimeMicros)) return -5;
                return 93;
            }
            case 10: {
                return 2002;
            }
            case 11: {
                return 0;
            }
            case 12: {
                return 2002;
            }
            case 13: {
                return 12;
            }
            case 14: {
                int n = INSTANCE.sqlType(AvroExtensionsKt.fromUnion(schema));
                return n;
            }
            default: {
                throw (Throwable)new SQLFeatureNotSupportedException();
            }
        }
    }

    private AvroSchemas() {
    }

    static {
        AvroSchemas avroSchemas;
        INSTANCE = avroSchemas = new AvroSchemas();
    }
}

