/*
 * Decompiled with CFR 0.152.
 */
package io.lenses.jdbc4;

import io.lenses.jdbc4.util.Logging;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\u0006J\u0006\u0010\b\u001a\u00020\u0006J\u0006\u0010\t\u001a\u00020\u0006J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/lenses/jdbc4/Versions;", "Lio/lenses/jdbc4/util/Logging;", "()V", "properties", "Ljava/util/Properties;", "databaseMajorVersion", "", "databaseMinorVersion", "driverMajorVersion", "driverMinorVersion", "loadOrDefault", "key", "", "lenses-jdbc"})
public final class Versions
implements Logging {
    private static final Properties properties;
    public static final Versions INSTANCE;

    private final int loadOrDefault(String key) {
        int n;
        String version = properties.getProperty(key);
        if (version == null) {
            this.getLogger().warn("Can not retrieve version information for this build.", null);
            n = -1;
        } else {
            String string = version;
            boolean bl = false;
            n = Integer.parseInt(string);
        }
        return n;
    }

    public final int driverMajorVersion() {
        return this.loadOrDefault("driver.major");
    }

    public final int driverMinorVersion() {
        return this.loadOrDefault("driver.minor");
    }

    public final int databaseMajorVersion() {
        return this.loadOrDefault("lenses.major");
    }

    public final int databaseMinorVersion() {
        return this.loadOrDefault("lenses.major");
    }

    private Versions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Versions versions;
        INSTANCE = versions = new Versions();
        properties = new Properties();
        Closeable closeable = versions.getClass().getResourceAsStream("/lsql.versions");
        boolean bl = false;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl2 = false;
            properties.load(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return Logging.DefaultImpls.getLogger(this);
    }
}

