/*
 * Decompiled with CFR 0.152.
 */
package io.lenses.jdbc4.resultset;

import arrow.Kind;
import arrow.core.Either;
import arrow.core.PredefKt;
import io.lenses.jdbc4.client.JdbcError;
import io.lenses.jdbc4.resultset.AvroSchemaResultSetMetaData;
import io.lenses.jdbc4.resultset.StreamingRowResultSet;
import io.lenses.jdbc4.resultset.WebsocketConnection;
import io.lenses.jdbc4.row.Row;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BG\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012&\u0010\b\u001a\"\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0005\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000b0\t\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\rH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0013H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u001b\u001a\u00020\u0010H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0014J\t\u0010\u001e\u001a\u00020\u0010H\u0096\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\b\u001a\"\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0005\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/lenses/jdbc4/resultset/WebSocketResultSet;", "Lio/lenses/jdbc4/resultset/StreamingRowResultSet;", "stmt", "Ljava/sql/Statement;", "schema", "Lorg/apache/avro/Schema;", "conn", "Lio/lenses/jdbc4/resultset/WebsocketConnection;", "converter", "Lkotlin/Function2;", "", "Larrow/core/Either;", "Lio/lenses/jdbc4/client/JdbcError$ParseError;", "Lio/lenses/jdbc4/row/Row;", "(Ljava/sql/Statement;Lorg/apache/avro/Schema;Lio/lenses/jdbc4/resultset/WebsocketConnection;Lkotlin/jvm/functions/Function2;)V", "completed", "", "row", "rowNumber", "", "close", "", "currentRow", "getMetaData", "Ljava/sql/ResultSetMetaData;", "getRow", "getStatement", "isClosed", "meta", "Lio/lenses/jdbc4/resultset/AvroSchemaResultSetMetaData;", "next", "lenses-jdbc"})
public final class WebSocketResultSet
extends StreamingRowResultSet {
    private int rowNumber;
    private Row row;
    private boolean completed;
    private final Statement stmt;
    private final Schema schema;
    private final WebsocketConnection conn;
    private final Function2<String, Schema, Either<JdbcError.ParseError, Row>> converter;

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean next() {
        boolean bl;
        if (this.completed) {
            bl = false;
        } else {
            String msg = this.conn.getQueue().take();
            if (msg == null) {
                this.row = null;
                this.completed = true;
                this.conn.close();
                bl = false;
            } else {
                void $receiver$iv;
                int n = this.rowNumber;
                this.rowNumber = n + 1;
                Kind kind = (Kind)this.converter.invoke((Object)msg, (Object)this.schema);
                WebSocketResultSet webSocketResultSet = this;
                void $receiver$iv$iv = $receiver$iv;
                Either this_$iv$iv = (Either)$receiver$iv$iv;
                Either either = this_$iv$iv;
                if (!(either instanceof Either.Right)) {
                    if (either instanceof Either.Left) {
                        Object it$iv = ((Either.Left)this_$iv$iv).getA();
                        JdbcError.ParseError it = (JdbcError.ParseError)it$iv;
                        boolean bl2 = false;
                        throw (Throwable)new SQLException(it.getCause());
                    }
                    throw new NoWhenBranchMatchedException();
                }
                Object p1$iv = ((Either.Right)this_$iv$iv).getB();
                Object object = PredefKt.identity((Object)p1$iv);
                webSocketResultSet.row = (Row)object;
                bl = this.row != null;
            }
        }
        return bl;
    }

    @Override
    public boolean isClosed() {
        return this.conn.isClosed();
    }

    @Override
    public void close() {
        this.conn.close();
    }

    @Override
    public int getRow() {
        return this.rowNumber;
    }

    @Override
    @NotNull
    public Row currentRow() {
        Row row = this.row;
        if (row == null) {
            Intrinsics.throwNpe();
        }
        return row;
    }

    @Override
    @NotNull
    public ResultSetMetaData getMetaData() {
        return this.meta();
    }

    @Override
    @NotNull
    protected AvroSchemaResultSetMetaData meta() {
        return new AvroSchemaResultSetMetaData(this.schema);
    }

    @Override
    @Nullable
    public Statement getStatement() {
        return this.stmt;
    }

    public WebSocketResultSet(@Nullable Statement stmt, @NotNull Schema schema, @NotNull WebsocketConnection conn2, @NotNull Function2<? super String, ? super Schema, ? extends Either<JdbcError.ParseError, ? extends Row>> converter) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)conn2, (String)"conn");
        Intrinsics.checkParameterIsNotNull(converter, (String)"converter");
        this.stmt = stmt;
        this.schema = schema;
        this.conn = conn2;
        this.converter = converter;
    }
}

