/*
 * Decompiled with CFR 0.152.
 */
package io.lenses.jdbc4.row;

import io.lenses.jdbc4.row.LongRowId;
import io.lenses.jdbc4.row.Row;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010!\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010#\u001a\u00020$2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016\u00a8\u0006%"}, d2={"Lio/lenses/jdbc4/row/ConvertingRow;", "Lio/lenses/jdbc4/row/Row;", "()V", "charStream", "Ljava/io/Reader;", "index", "", "getBigDecimal", "Ljava/math/BigDecimal;", "scale", "getBoolean", "", "getByte", "", "getBytes", "", "getDate", "Ljava/sql/Date;", "cal", "Ljava/util/Calendar;", "getDouble", "", "getFloat", "", "getInt", "getLong", "", "getRowId", "Ljava/sql/RowId;", "getShort", "", "getString", "", "getTime", "Ljava/sql/Time;", "getTimestamp", "Ljava/sql/Timestamp;", "lenses-jdbc"})
public abstract class ConvertingRow
implements Row {
    @Override
    public byte getByte(int index) {
        byte by;
        Object value = this.getObject(index);
        if (value instanceof Integer) {
            by = (byte)((Number)value).intValue();
        } else if (value instanceof Long) {
            by = (byte)((Number)value).longValue();
        } else if (value instanceof String) {
            String string = (String)value;
            boolean bl = false;
            by = Byte.parseByte(string);
        } else {
            throw (Throwable)new SQLException("Unable to convert " + value + " to byte");
        }
        return by;
    }

    @Override
    @NotNull
    public Reader charStream(int index) {
        Object value = this.getObject(index);
        if (!(value instanceof String)) {
            throw (Throwable)new SQLException("Unable to convert " + value + " to Reader");
        }
        return new StringReader((String)value);
    }

    @Override
    public float getFloat(int index) {
        float f;
        Object value = this.getObject(index);
        if (value instanceof Double) {
            f = (float)((Number)value).doubleValue();
        } else if (value instanceof Float) {
            f = ((Number)value).floatValue();
        } else if (value instanceof String) {
            String string = (String)value;
            boolean bl = false;
            f = Float.parseFloat(string);
        } else {
            throw (Throwable)new SQLException("Unable to convert " + value + " to float");
        }
        return f;
    }

    @Override
    public boolean getBoolean(int index) {
        boolean bl;
        Object value = this.getObject(index);
        if (value instanceof Boolean) {
            bl = (Boolean)value;
        } else if (value instanceof String) {
            bl = Intrinsics.areEqual((Object)value, (Object)"true");
        } else {
            throw (Throwable)new SQLException("Unable to convert " + value + " to boolean");
        }
        return bl;
    }

    @Override
    @NotNull
    public BigDecimal getBigDecimal(int index, int scale) {
        BigDecimal bigDecimal;
        Object value = this.getObject(index);
        if (value instanceof Long) {
            BigDecimal bigDecimal2 = BigDecimal.valueOf(((Number)value).longValue(), scale);
            bigDecimal = bigDecimal2;
            Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal2, (String)"BigDecimal.valueOf(value, scale)");
        } else if (value instanceof Integer) {
            BigDecimal bigDecimal3 = BigDecimal.valueOf(((Number)value).intValue(), scale);
            bigDecimal = bigDecimal3;
            Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal3, (String)"BigDecimal.valueOf(value.toLong(), scale)");
        } else if (value instanceof String) {
            bigDecimal = new BigDecimal((String)value);
        } else {
            throw (Throwable)new SQLException("Unable to convert " + value + " to BigDecimal");
        }
        return bigDecimal;
    }

    @Override
    @NotNull
    public BigDecimal getBigDecimal(int index) {
        BigDecimal bigDecimal;
        Object value = this.getObject(index);
        if (value instanceof Long) {
            BigDecimal bigDecimal2 = BigDecimal.valueOf(((Number)value).longValue());
            bigDecimal = bigDecimal2;
            Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal2, (String)"BigDecimal.valueOf(value)");
        } else if (value instanceof Integer) {
            BigDecimal bigDecimal3 = BigDecimal.valueOf(((Number)value).intValue());
            bigDecimal = bigDecimal3;
            Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal3, (String)"BigDecimal.valueOf(value.toLong())");
        } else if (value instanceof Double) {
            BigDecimal bigDecimal4 = BigDecimal.valueOf(((Number)value).doubleValue());
            bigDecimal = bigDecimal4;
            Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal4, (String)"BigDecimal.valueOf(value)");
        } else if (value instanceof Float) {
            BigDecimal bigDecimal5 = BigDecimal.valueOf(((Number)value).floatValue());
            bigDecimal = bigDecimal5;
            Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal5, (String)"BigDecimal.valueOf(value.toDouble())");
        } else if (value instanceof String) {
            bigDecimal = new BigDecimal((String)value);
        } else {
            throw (Throwable)new SQLException("Unable to convert " + value + " to BigDecimal");
        }
        return bigDecimal;
    }

    @Override
    @NotNull
    public Time getTime(int index) {
        return this.getTime(index, null);
    }

    @Override
    @NotNull
    public Time getTime(int index, @Nullable Calendar cal) {
        Instant instant;
        Object value = this.getObject(index);
        if (value instanceof Integer) {
            instant = Instant.ofEpochMilli(((Number)value).intValue());
        } else if (value instanceof Long) {
            instant = Instant.ofEpochMilli(((Number)value).longValue());
        } else if (value instanceof String) {
            String string = (String)value;
            boolean bl = false;
            instant = Instant.ofEpochMilli(Long.parseLong(string));
        } else {
            throw (Throwable)new SQLException("Unable to convert " + value + " to Time");
        }
        Instant instant2 = instant;
        Serializable serializable = cal;
        if (serializable == null || (serializable = ((Calendar)serializable).getTimeZone()) == null || (serializable = ((TimeZone)serializable).toZoneId()) == null) {
            serializable = ZoneId.of("Z");
        }
        Serializable zone = serializable;
        Time time = Time.valueOf(instant2.atZone((ZoneId)zone).toLocalTime());
        Intrinsics.checkExpressionValueIsNotNull((Object)time, (String)"Time.valueOf(instant.atZone(zone).toLocalTime())");
        return time;
    }

    @Override
    @NotNull
    public Date getDate(int index) {
        return this.getDate(index, null);
    }

    @Override
    @NotNull
    public Date getDate(int index, @Nullable Calendar cal) {
        Instant instant;
        Object value = this.getObject(index);
        if (value instanceof Integer) {
            instant = Instant.ofEpochMilli(((Number)value).intValue());
        } else if (value instanceof Long) {
            instant = Instant.ofEpochMilli(((Number)value).longValue());
        } else if (value instanceof String) {
            String string = (String)value;
            boolean bl = false;
            instant = Instant.ofEpochMilli(Long.parseLong(string));
        } else {
            throw (Throwable)new SQLException("Unable to convert " + value + " to java.sql.Date");
        }
        Instant instant2 = instant;
        Serializable serializable = cal;
        if (serializable == null || (serializable = ((Calendar)serializable).getTimeZone()) == null || (serializable = ((TimeZone)serializable).toZoneId()) == null) {
            serializable = ZoneId.of("Z");
        }
        Serializable zone = serializable;
        return new Date(instant2.atZone((ZoneId)zone).toInstant().toEpochMilli());
    }

    @Override
    @NotNull
    public Timestamp getTimestamp(int index) {
        return this.getTimestamp(index, null);
    }

    @Override
    @NotNull
    public Timestamp getTimestamp(int index, @Nullable Calendar cal) {
        Instant instant;
        Object value = this.getObject(index);
        if (value instanceof Integer) {
            instant = Instant.ofEpochMilli(((Number)value).intValue());
        } else if (value instanceof Long) {
            instant = Instant.ofEpochMilli(((Number)value).longValue());
        } else if (value instanceof String) {
            String string = (String)value;
            boolean bl = false;
            instant = Instant.ofEpochMilli(Long.parseLong(string));
        } else {
            throw (Throwable)new SQLException("Unable to convert " + value + " to Timestamp");
        }
        Instant instant2 = instant;
        Serializable serializable = cal;
        if (serializable == null || (serializable = ((Calendar)serializable).getTimeZone()) == null || (serializable = ((TimeZone)serializable).toZoneId()) == null) {
            serializable = ZoneId.of("Z");
        }
        Serializable zone = serializable;
        Timestamp timestamp = Timestamp.valueOf(instant2.atZone((ZoneId)zone).toLocalDateTime());
        Intrinsics.checkExpressionValueIsNotNull((Object)timestamp, (String)"Timestamp.valueOf(instan\u2026(zone).toLocalDateTime())");
        return timestamp;
    }

    @Override
    @NotNull
    public byte[] getBytes(int index) {
        Object value = this.getObject(index);
        if (!(value instanceof byte[])) {
            throw (Throwable)new SQLException("Unable to convert " + value + " to byte[]");
        }
        return (byte[])value;
    }

    @Override
    public double getDouble(int index) {
        double d;
        Object value = this.getObject(index);
        if (value instanceof Double) {
            d = ((Number)value).doubleValue();
        } else if (value instanceof Float) {
            d = ((Number)value).floatValue();
        } else if (value instanceof Integer) {
            d = ((Number)value).intValue();
        } else if (value instanceof Long) {
            d = ((Number)value).longValue();
        } else if (value instanceof String) {
            String string = (String)value;
            boolean bl = false;
            d = Double.parseDouble(string);
        } else {
            throw (Throwable)new SQLException("Unable to convert " + value + " to double");
        }
        return d;
    }

    @Override
    @Nullable
    public String getString(int index) {
        Object value;
        Object object = value = this.getObject(index);
        return object != null ? object.toString() : null;
    }

    @Override
    public long getLong(int index) {
        long l;
        Object value = this.getObject(index);
        if (value instanceof Integer) {
            l = ((Number)value).intValue();
        } else if (value instanceof Long) {
            l = ((Number)value).longValue();
        } else if (value instanceof String) {
            String string = (String)value;
            boolean bl = false;
            l = Long.parseLong(string);
        } else {
            throw (Throwable)new SQLException("Unable to convert " + value + " to String");
        }
        return l;
    }

    @Override
    public int getInt(int index) {
        int n;
        Object value = this.getObject(index);
        if (value instanceof Integer) {
            n = ((Number)value).intValue();
        } else if (value instanceof Long) {
            n = (int)((Number)value).longValue();
        } else if (value instanceof String) {
            String string = (String)value;
            boolean bl = false;
            n = Integer.parseInt(string);
        } else {
            throw (Throwable)new SQLException("Unable to convert " + value + " to int");
        }
        return n;
    }

    @Override
    public short getShort(int index) {
        short s;
        Object value = this.getObject(index);
        if (value instanceof Integer) {
            s = (short)((Number)value).intValue();
        } else if (value instanceof Long) {
            s = (short)((Number)value).longValue();
        } else if (value instanceof String) {
            String string = (String)value;
            boolean bl = false;
            s = Short.parseShort(string);
        } else {
            throw (Throwable)new SQLException("Unable to convert " + value + " to short");
        }
        return s;
    }

    @Override
    @NotNull
    public RowId getRowId(int index) {
        return new LongRowId(index);
    }
}

