/*
 * Decompiled with CFR 0.152.
 */
package io.leonard;

import io.leonard.Position;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public final class PolylineUtils {
    private static final double SIMPLIFY_DEFAULT_TOLERANCE = 1.0;
    private static final boolean SIMPLIFY_DEFAULT_HIGHEST_QUALITY = false;

    private PolylineUtils() {
    }

    @Nonnull
    public static List<Position> decode(@Nonnull String encodedPath, int precision) {
        int len = encodedPath.length();
        double factor = Math.pow(10.0, precision);
        ArrayList<Position> path = new ArrayList<Position>();
        int index = 0;
        int lat = 0;
        int lng = 0;
        while (index < len) {
            int temp;
            int result = 1;
            int shift = 0;
            do {
                temp = encodedPath.charAt(index++) - 63 - 1;
                result += temp << shift;
                shift += 5;
            } while (temp >= 31);
            lat += (result & 1) != 0 ? ~(result >> 1) : result >> 1;
            result = 1;
            shift = 0;
            do {
                temp = encodedPath.charAt(index++) - 63 - 1;
                result += temp << shift;
                shift += 5;
            } while (temp >= 31);
            path.add(Position.fromLngLat((double)(lng += (result & 1) != 0 ? ~(result >> 1) : result >> 1) / factor, (double)lat / factor));
        }
        return path;
    }

    @Nonnull
    public static String encode(@Nonnull List<Position> path, int precision) {
        long lastLat = 0L;
        long lastLng = 0L;
        StringBuilder result = new StringBuilder();
        double factor = Math.pow(10.0, precision);
        for (Position point : path) {
            long lat = Math.round(point.getLatitude() * factor);
            long lng = Math.round(point.getLongitude() * factor);
            long varLat = lat - lastLat;
            long varLng = lng - lastLng;
            PolylineUtils.encode(varLat, result);
            PolylineUtils.encode(varLng, result);
            lastLat = lat;
            lastLng = lng;
        }
        return result.toString();
    }

    private static void encode(long variable, StringBuilder result) {
        long l = variable = variable < 0L ? variable << 1 ^ 0xFFFFFFFFFFFFFFFFL : variable << 1;
        while (variable >= 32L) {
            result.append(Character.toChars((int)((0x20L | variable & 0x1FL) + 63L)));
            variable >>= 5;
        }
        result.append(Character.toChars((int)(variable + 63L)));
    }

    @Nonnull
    public static List<Position> simplify(@Nonnull List<Position> points) {
        return PolylineUtils.simplify(points, 1.0, false);
    }

    @Nonnull
    public static List<Position> simplify(@Nonnull List<Position> points, double tolerance) {
        return PolylineUtils.simplify(points, tolerance, false);
    }

    @Nonnull
    public static List<Position> simplify(@Nonnull List<Position> points, boolean highestQuality) {
        return PolylineUtils.simplify(points, 1.0, highestQuality);
    }

    @Nonnull
    public static List<Position> simplify(@Nonnull List<Position> points, double tolerance, boolean highestQuality) {
        if (points.size() <= 2) {
            return points;
        }
        double sqTolerance = tolerance * tolerance;
        points = highestQuality ? points : PolylineUtils.simplifyRadialDist(points, sqTolerance);
        points = PolylineUtils.simplifyDouglasPeucker(points, sqTolerance);
        return points;
    }

    private static double getSqDist(Position p1, Position p2) {
        double dx = p1.getLongitude() - p2.getLongitude();
        double dy = p1.getLatitude() - p2.getLatitude();
        return dx * dx + dy * dy;
    }

    private static double getSqSegDist(Position point, Position p1, Position p2) {
        double horizontal = p1.getLongitude();
        double vertical = p1.getLatitude();
        double diffHorizontal = p2.getLongitude() - horizontal;
        double diffVertical = p2.getLatitude() - vertical;
        if (diffHorizontal != 0.0 || diffVertical != 0.0) {
            double total = ((point.getLongitude() - horizontal) * diffHorizontal + (point.getLatitude() - vertical) * diffVertical) / (diffHorizontal * diffHorizontal + diffVertical * diffVertical);
            if (total > 1.0) {
                horizontal = p2.getLongitude();
                vertical = p2.getLatitude();
            } else if (total > 0.0) {
                horizontal += diffHorizontal * total;
                vertical += diffVertical * total;
            }
        }
        diffHorizontal = point.getLongitude() - horizontal;
        diffVertical = point.getLatitude() - vertical;
        return diffHorizontal * diffHorizontal + diffVertical * diffVertical;
    }

    private static List<Position> simplifyRadialDist(List<Position> points, double sqTolerance) {
        Position prevPoint = points.get(0);
        ArrayList<Position> newPoints = new ArrayList<Position>();
        newPoints.add(prevPoint);
        Position point = null;
        int len = points.size();
        for (int i = 1; i < len; ++i) {
            point = points.get(i);
            if (!(PolylineUtils.getSqDist(point, prevPoint) > sqTolerance)) continue;
            newPoints.add(point);
            prevPoint = point;
        }
        if (!prevPoint.equals(point)) {
            newPoints.add(point);
        }
        return newPoints;
    }

    private static List<Position> simplifyDpStep(List<Position> points, int first, int last, double sqTolerance, List<Position> simplified) {
        double maxSqDist = sqTolerance;
        int index = 0;
        ArrayList<Position> stepList = new ArrayList<Position>();
        for (int i = first + 1; i < last; ++i) {
            double sqDist = PolylineUtils.getSqSegDist(points.get(i), points.get(first), points.get(last));
            if (!(sqDist > maxSqDist)) continue;
            index = i;
            maxSqDist = sqDist;
        }
        if (maxSqDist > sqTolerance) {
            if (index - first > 1) {
                stepList.addAll(PolylineUtils.simplifyDpStep(points, first, index, sqTolerance, simplified));
            }
            stepList.add(points.get(index));
            if (last - index > 1) {
                stepList.addAll(PolylineUtils.simplifyDpStep(points, index, last, sqTolerance, simplified));
            }
        }
        return stepList;
    }

    private static List<Position> simplifyDouglasPeucker(List<Position> points, double sqTolerance) {
        int last = points.size() - 1;
        ArrayList<Position> simplified = new ArrayList<Position>();
        simplified.add(points.get(0));
        simplified.addAll(PolylineUtils.simplifyDpStep(points, 0, last, sqTolerance, simplified));
        simplified.add(points.get(last));
        return simplified;
    }
}

