/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.autounit;

import io.leopard.autounit.BeanAssert;
import io.leopard.autounit.BeanStubber;
import io.leopard.autounit.inject.Inject;
import io.leopard.autounit.inject.InjectContext;
import io.leopard.autounit.inject.InjectImpl;
import io.leopard.autounit.unitdb.ConnectionContext;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class AutoUnit {
    private static Map<Integer, InjectContext> injectContextMap = new HashMap<Integer, InjectContext>();
    private static InjectImpl inject = new InjectImpl();
    private static Map<Integer, Object> beanMap = new HashMap<Integer, Object>();

    public static void assertBean(Class<?> clazz) {
        BeanAssert.assertBean(AutoUnit.mock(clazz));
    }

    public static void assertBean(Class<?> clazz, boolean log) {
        BeanAssert.assertBean(AutoUnit.mock(clazz), log);
    }

    public static void rollabck() {
        for (Connection conn : ConnectionContext.list()) {
            try {
                conn.rollback();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static void clean(Object bean) {
        InjectContext context = injectContextMap.get(bean.hashCode());
        if (context == null) {
            throw new IllegalArgumentException("Bean[" + bean + "]\u672amock.");
        }
        for (Inject inject : context.listInject()) {
            inject.clean();
        }
    }

    public static <T> T mock(Class<T> clazz) {
        Field[] fields;
        Object bean = beanMap.get(clazz.hashCode());
        if (bean != null) {
            return (T)bean;
        }
        try {
            bean = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        InjectContext context = new InjectContext(bean);
        for (Field field : fields = clazz.getDeclaredFields()) {
            Inject inject2 = inject.inject(bean, field);
            if (inject2 == null) continue;
            context.add(inject2, field);
        }
        injectContextMap.put(bean.hashCode(), context);
        beanMap.put(clazz.hashCode(), bean);
        return (T)bean;
    }

    public static BeanStubber tson(String tson) {
        return new BeanStubber(tson);
    }

    public static <T> T dao(Class<T> clazz) {
        return AutoUnit.dao(clazz, false);
    }

    public static <T> T dao(Class<T> clazz, boolean log) {
        T bean = AutoUnit.mock(clazz);
        return new BeanStubber("").dao(bean, log);
    }
}

