/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.autounit;

import java.lang.reflect.Method;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.MethodInfo;

public class CtClassUtil {
    private static final ClassPool pool = ClassPool.getDefault();

    public static CtClass getClass(Class<?> clazz) {
        try {
            return pool.get(clazz.getName());
        }
        catch (NotFoundException e) {
            Throwable error = e.getCause();
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            if (error instanceof Exception) {
                throw new RuntimeException(error.getMessage(), error);
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static CtMethod getMethod(Class<?> clazz, Method method) throws NotFoundException {
        CtMethod ctMethod;
        CtClass ctClass = CtClassUtil.getClass(clazz);
        Class<?>[] types = method.getParameterTypes();
        if (types == null) {
            ctMethod = ctClass.getDeclaredMethod(method.getName());
        } else {
            CtClass[] params = new CtClass[types.length];
            for (int i = 0; i < params.length; ++i) {
                params[i] = CtClassUtil.getClass(types[i]);
            }
            ctMethod = ctClass.getDeclaredMethod(method.getName(), params);
        }
        return ctMethod;
    }

    public static String[] getParameterNames(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        return CtClassUtil.getParameterNames(clazz, method);
    }

    public static String[] getParameterNames(Class<?> clazz, Method method) {
        String[] names;
        CtMethod ctMethod;
        try {
            ctMethod = CtClassUtil.getMethod(clazz, method);
        }
        catch (NotFoundException e) {
            Throwable error = e.getCause();
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            if (error instanceof Exception) {
                throw new RuntimeException(error.getMessage(), error);
            }
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            names = CtClassUtil.getParameterNames(ctMethod);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return names;
    }

    public static String[] getParameterNames(CtMethod ctMethod) throws NotFoundException {
        MethodInfo methodInfo = ctMethod.getMethodInfo();
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        LocalVariableAttribute attribute = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
        String[] paramNames = new String[ctMethod.getParameterTypes().length];
        int pos = 0;
        int size = attribute.tableLength();
        if (size > 0) {
            String[] names = new String[size - 1];
            for (int i = 0; i < names.length; ++i) {
                names[i] = attribute.variableName(i);
                if (!"this".equals(names[i])) continue;
                pos = i + 1;
                break;
            }
        }
        for (int i = 0; i < paramNames.length; ++i) {
            paramNames[i] = attribute.variableName(i + pos);
            continue;
        }
        return paramNames;
    }
}

