/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.autounit;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PackageUtil {
    public static List<Class<?>> getClassList(String packageName, boolean includeSubPackage) {
        Set<Class<?>> classes = PackageUtil.getClasses(packageName, includeSubPackage);
        ArrayList result = new ArrayList();
        for (Class<?> clazz : classes) {
            if (clazz.isInterface() || clazz.getSimpleName().endsWith("Test") || clazz.getName().indexOf("$") != -1) continue;
            result.add(clazz);
        }
        return result;
    }

    protected static Set<Class<?>> getClasses(String packageName, String path, boolean includeSubPackage) {
        File[] files;
        HashSet classes = new HashSet();
        String end = ".class";
        for (File file : files = new File(path).listFiles()) {
            Class<?> c;
            String name = file.getName();
            if (includeSubPackage && file.isDirectory()) {
                classes.addAll(PackageUtil.getClasses(packageName + "." + name, file.getPath(), includeSubPackage));
            }
            if (!name.endsWith(end)) continue;
            String className = name.substring(0, name.length() - end.length());
            try {
                c = Class.forName(packageName + "." + className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            classes.add(c);
        }
        return classes;
    }

    public static Set<Class<?>> getClasses(String packageName, boolean includeSubPackage) {
        HashSet classes = new HashSet();
        boolean recursive = true;
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    if (filePath.indexOf("$") != -1) {
                        System.out.println("filePath:" + filePath);
                        continue;
                    }
                    classes.addAll(PackageUtil.getClasses(packageName, filePath, includeSubPackage));
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                try {
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (name.charAt(0) == '/') {
                            name = name.substring(1);
                        }
                        if (!name.startsWith(packageDirName)) continue;
                        int idx = name.lastIndexOf(47);
                        if (idx != -1) {
                            packageName = name.substring(0, idx).replace('/', '.');
                        }
                        if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                        String className = name.substring(packageName.length() + 1, name.length() - 6);
                        try {
                            classes.add(Class.forName(packageName + '.' + className));
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return classes;
    }
}

