/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.autounit.inject;

import io.leopard.autounit.config.AutoUnitConfigImpl;
import io.leopard.autounit.inject.Inject;
import io.leopard.autounit.inject.InjectDaoImpl;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class InjectImpl
implements Inject {
    private List<Inject> list = new ArrayList<Inject>();

    public InjectImpl() {
        List<Inject> ruleList = this.listCustomRule();
        this.list.addAll(ruleList);
        this.list.add(new InjectDaoImpl());
    }

    @Override
    public Inject inject(Object bean, Field field) {
        for (Inject inject : this.list) {
            Inject inject2 = inject.inject(bean, field);
            if (inject2 == null) continue;
            return inject2;
        }
        return null;
    }

    protected List<Inject> listCustomRule() {
        List<String> classNameList;
        try {
            classNameList = new AutoUnitConfigImpl().listRule();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        ArrayList<Inject> ruleList = new ArrayList<Inject>();
        for (String className : classNameList) {
            try {
                Class<?> clazz = Class.forName(className);
                Inject inject = (Inject)clazz.newInstance();
                ruleList.add(inject);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("ClassNotFoundException:" + e.getMessage(), e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return ruleList;
    }

    @Override
    public boolean clean() {
        throw new UnsupportedOperationException("Not Impl.");
    }
}

