/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.autounit.rule;

import io.leopard.autounit.AutoUnitLog;
import io.leopard.autounit.rule.MethodHuman;
import io.leopard.autounit.rule.NoSuchMethodRuntimeException;
import io.leopard.autounit.rule.UnitMethod;
import io.leopard.autounit.tson.Tson;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MethodHumanAddImpl
implements MethodHuman {
    @Override
    public Method find(Object bean) throws NoSuchMethodRuntimeException {
        Class<?> clazz = bean.getClass();
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals("add") || method.isBridge()) continue;
            return method;
        }
        throw new NoSuchMethodRuntimeException("add");
    }

    @Override
    public Object invoke(UnitMethod unitMethod, boolean log) throws NoSuchMethodRuntimeException {
        Object result;
        Method method = this.find(unitMethod.getBean());
        if (method == null) {
            return false;
        }
        Object arg = Tson.toObject(method.getParameterTypes()[0], unitMethod.getTson(), unitMethod.getNames(), unitMethod.getArgs());
        try {
            result = method.invoke(unitMethod.getBean(), arg);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (log) {
            AutoUnitLog.log(method, result, arg);
        }
        return result;
    }
}

