/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.autounit.tson;

import java.util.Date;

public class TsonDataType {
    public static Object toObject(String value, Class<?> type) {
        if (type.equals(String.class)) {
            return value;
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return Boolean.parseBoolean(value);
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return Integer.parseInt(value);
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return Long.parseLong(value);
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return Double.parseDouble(value);
        }
        if (type.equals(Date.class)) {
            return TsonDataType.parseDate(value);
        }
        throw new IllegalArgumentException("\u7c7b\u578b[" + type.getName() + "]\u8f6c\u6362\u5931\u8d25[" + value + "]");
    }

    protected static long toTime(String str) {
        if (str.endsWith("ms")) {
            return Long.parseLong(str.replace("ms", ""));
        }
        if (str.endsWith("s")) {
            return Long.parseLong(str.replace("s", "")) * 1000L;
        }
        if (str.endsWith("m")) {
            return Long.parseLong(str.replace("m", "")) * 60L * 1000L;
        }
        if (str.endsWith("h")) {
            return Long.parseLong(str.replace("h", "")) * 60L * 60L * 1000L;
        }
        if (str.endsWith("D")) {
            return Long.parseLong(str.replace("D", "")) * 60L * 60L * 1000L * 24L;
        }
        throw new RuntimeException("\u975e\u6cd5\u65f6\u95f4[" + str + "].");
    }

    protected static Date parseDate(String str) {
        if ("now".equalsIgnoreCase(str)) {
            return new Date();
        }
        if (str.startsWith("now+")) {
            long time = System.currentTimeMillis() + TsonDataType.toTime(str.substring(4));
            return new Date(time);
        }
        if (str.startsWith("now-")) {
            long time = System.currentTimeMillis() - TsonDataType.toTime(str.substring(4));
            return new Date(time);
        }
        return new Date(Long.parseLong(str));
    }
}

