/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.autounit.tson;

import io.leopard.autounit.tson.FieldValue;
import io.leopard.autounit.tson.FieldValueImpl;
import io.leopard.autounit.tson.TsonDataType;
import io.leopard.autounit.tson.TsonService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TsonServiceImpl
implements TsonService {
    private FieldValue fieldValue = new FieldValueImpl();

    @Override
    public <T> T toObject(Class<T> clazz, Map<String, String> data) throws Exception {
        Object bean = this.fieldValue.get(clazz, null);
        for (Map.Entry<String, String> entry : data.entrySet()) {
            Field field;
            String key = entry.getKey();
            try {
                field = clazz.getDeclaredField(key);
            }
            catch (NoSuchFieldException e) {
                throw new NoSuchFieldException(e.getMessage() + " clazz:" + clazz.getName());
            }
            field.setAccessible(true);
            Object value = TsonDataType.toObject(entry.getValue(), field.getType());
            field.set(bean, value);
        }
        return (T)bean;
    }

    public static String[] split(String str, Character separator) {
        if (str.indexOf(39) == -1 && str.indexOf(34) == -1) {
            return str.split(separator.toString());
        }
        ArrayList<String> list = new ArrayList<String>();
        char[] chars = str.toCharArray();
        int prefix = 0;
        boolean hasQuotes = false;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\'' || chars[i] == '\"') {
                hasQuotes = !hasQuotes;
                continue;
            }
            if (chars[i] != separator.charValue() || hasQuotes) continue;
            String word = str.substring(prefix, i);
            list.add(word);
            prefix = i + 1;
        }
        if (prefix < chars.length) {
            list.add(str.substring(prefix));
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public Map<String, String> toMap(String tson) {
        String[] strs;
        tson = tson.replace("{", "");
        tson = tson.replace("}", "");
        HashMap<String, String> data = new HashMap<String, String>();
        if (tson.length() == 0) {
            return data;
        }
        for (String str : strs = TsonServiceImpl.split(tson, Character.valueOf(','))) {
            String[] block = TsonServiceImpl.split(str, Character.valueOf(':'));
            String fieldName = block[0];
            String value = block[1].replace("\"", "");
            data.put(fieldName, value);
        }
        return data;
    }

    @Override
    public <T> T toObject(Class<T> clazz, String tson) throws Exception {
        Map<String, String> data = this.toMap(tson);
        return this.toObject(clazz, data);
    }
}

