/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.autounit.unitdb;

import io.leopard.autounit.unitdb.DatabaseScript;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import javax.xml.bind.annotation.XmlID;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.jdbc.datasource.init.ScriptStatementFailedException;
import org.springframework.util.StringUtils;

public class DatabaseScriptImpl
implements DatabaseScript {
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public boolean populate(Class<?> entityClazz, String tableName) {
        return this.populate(entityClazz, tableName, false);
    }

    protected boolean isKey(Field field) {
        XmlID id = field.getAnnotation(XmlID.class);
        return id != null;
    }

    protected String toDataType(Field field) {
        Class<?> type = field.getType();
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return "int(10) unsigned NOT NULL DEFAULT 0,";
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return "int(11) unsigned NOT NULL DEFAULT 0,";
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return "DECIMAL(10, 6) NOT NULL DEFAULT 0.0,";
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return "DECIMAL(10, 6) NOT NULL DEFAULT 0.0,";
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return "tinyint unsigned NOT NULL DEFAULT 0,";
        }
        if (type.equals(String.class)) {
            return "varchar(255) NOT NULL DEFAULT '',";
        }
        if (type.equals(Date.class)) {
            return "datetime NOT NULL DEFAULT '1970-01-01 00:00:00',";
        }
        throw new IllegalArgumentException("\u672a\u77e5\u6570\u636e\u7c7b\u578b[" + type.getName() + "].");
    }

    protected String generateSql(Class<?> entityClazz, String tableName) {
        Field[] fields = entityClazz.getDeclaredFields();
        ArrayList<String> keyList = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        sb.append("create table ").append(tableName).append(" (\n");
        for (Field field : fields) {
            String fieldName = field.getName();
            String dataType = this.toDataType(field);
            sb.append("\t`" + fieldName + "` ").append(dataType).append("\n");
            if (!this.isKey(field)) continue;
            keyList.add("`" + fieldName + "`");
        }
        sb.append("\tPRIMARY KEY (" + StringUtils.collectionToDelimitedString(keyList, (String)",") + ")\n");
        sb.append(");\n");
        return sb.toString();
    }

    @Override
    public boolean populate(Class<?> entityClazz, String tableName, boolean dropTable) {
        String sql = this.generateSql(entityClazz, tableName);
        return this.populate(sql, dropTable);
    }

    @Override
    public boolean populate(String sql) {
        return this.populate(sql, false);
    }

    protected String parseTableName(String sql) {
        sql = sql.replace("`", "");
        Pattern p = Pattern.compile("create table\\s+([a-zA-Z0-9\\-_]+)", 2);
        Matcher m = p.matcher(sql);
        if (m.find()) {
            return m.group(1);
        }
        throw new IllegalArgumentException("\u89e3\u6790\u8868\u540d\u51fa\u9519.");
    }

    protected void dropTable(String tableName) {
        String sql = "DROP TABLE IF EXISTS `" + tableName + "`;";
        ByteArrayResource scripts = new ByteArrayResource(sql.getBytes());
        ResourceDatabasePopulator populator = new ResourceDatabasePopulator(new Resource[]{scripts});
        DatabasePopulatorUtils.execute((DatabasePopulator)populator, (DataSource)this.dataSource);
    }

    @Override
    public boolean populate(String sql, boolean dropTable) {
        if (dropTable) {
            String tableName = this.parseTableName(sql);
            this.dropTable(tableName);
        }
        ByteArrayResource scripts = new ByteArrayResource(sql.getBytes());
        ResourceDatabasePopulator populator = new ResourceDatabasePopulator(new Resource[]{scripts});
        try {
            DatabasePopulatorUtils.execute((DatabasePopulator)populator, (DataSource)this.dataSource);
            return true;
        }
        catch (ScriptStatementFailedException e) {
            return false;
        }
    }

    public static boolean populate(DataSource dataSource, Class<?> entityClazz, String tableName) {
        DatabaseScriptImpl databaseScript = new DatabaseScriptImpl();
        databaseScript.setDataSource(dataSource);
        return databaseScript.populate(entityClazz, tableName);
    }
}

