package io.leopard.topnb;

import java.util.HashSet;
import java.util.Set;

import org.springframework.aop.framework.autoproxy.BeanNameAutoProxyCreator;

public class BeanNameAutoProxyCreatorBean extends BeanNameAutoProxyCreator {

	private static final long serialVersionUID = 1L;

	// <bean
	// class="org.springframework.aop.framework.autoproxy.BeanNameAutoProxyCreator">
	// <property name="beanNames">
	// <list>
	// <value>*Dao</value>
	// <value>*DaoMysqlImpl</value>
	// <value>*DaoMemcachedImpl</value>
	// <value>*DaoCacheImpl</value>
	// <value>*DaoRedisImpl</value>
	// <value>*DaoHttpImpl</value>
	// <value>*DaoOutsideImpl</value>
	// <value>*Controller</value>
	// </list>
	// </property>
	// <property name="interceptorNames">
	// <list>
	// <value>performanceMonitorInterceptor</value>
	// </list>
	// </property>
	// </bean>
	public BeanNameAutoProxyCreatorBean() {
		// System.err.println("new BeanNameAutoProxyCreatorBean");
		String[] beanNames = new String[] { "*Dao"//
				, "*DaoMysqlImpl"//
				, "*DaoMemcachedImpl"//
				, "*DaoCacheImpl"//
				, "*DaoRedisImpl"//
				, "*DaoHttpImpl"//
				, "*DaoOutsideImpl"//
				, "*DaoOtherImpl"//
				, "*DaoThriftImpl"//
				, "*DaoFileImpl"//
				, "*DaoImpl"//
				, "*DaoMemoryImpl"//
				, "*Service"//
				, "*Controller"//
		};
		this.setBeanNames(beanNames);
		this.setInterceptorNames(new String[] { "topnbInterceptor" });
	}

	private static Set<String> IGNORED_BEAN_NAME_SET = new HashSet<String>();
	static {
		IGNORED_BEAN_NAME_SET.add("conversionService");
	}

	@Override
	protected boolean isMatch(String beanName, String mappedName) {
		// System.err.println("beanName:" + beanName + " mappedName:" +
		// mappedName);
		if (IGNORED_BEAN_NAME_SET.contains(beanName)) {
			return false;
		}

		return super.isMatch(beanName, mappedName);
	}
}
