package io.leopard.topnb;

import io.leopard.topnb.service.PerformanceService;

/**
 * Leopard Web层耗时.
 * 
 * @author 阿海
 * 
 */
public class LeopardWebTimeLog {

	private static final PerformanceService performanceService = TopnbBeanFactory.getPerformanceService();

	private static final ThreadLocal<Long> TIME = new ThreadLocal<Long>();

	public static void start() {
		long time = System.nanoTime();
		TIME.set(time);
	}

	public static void stop() {
		long startTime = TIME.get();
		long endTime = System.nanoTime();

		long time = (endTime - startTime) / 1000L; // time 单位:微妙

		String methodName = "io.leopard.web.userinfo.UserinfoFilter.doLeopardFilter";

		performanceService.add(methodName, time);
	}
}
