package io.leopard.topnb;

import io.leopard.topnb.service.PerformanceHandler;
import io.leopard.topnb.service.PerformanceService;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class TopnbBeanFactory {
	protected static final Log logger = LogFactory.getLog(TopnbBeanFactory.class);

	private static AbstractApplicationContext applicationContext;

	protected static synchronized AbstractApplicationContext getApplicationContext() {

		if (applicationContext == null) {
			String[] filenames = { "/topnb/applicationContext-service.xml" };
			applicationContext = new ClassPathXmlApplicationContext(filenames);
		}
		return applicationContext;
	}

	private static boolean isEnableMonitor = false;

	public static boolean isEnableMonitor() {
		return isEnableMonitor;
	}

	public static void setEnableMonitor(boolean isEnableMonitor) {
		TopnbBeanFactory.isEnableMonitor = isEnableMonitor;
	}

	public static ClassPathXmlApplicationContext getContext(String configLocation) {
		boolean isEnableMonitor = isEnableMonitor();
		return getContext(configLocation, isEnableMonitor);
	}

	protected static ClassPathXmlApplicationContext getContext(String configLocation, boolean isEnableMonitor) {
		if (isEnableMonitor) {
			return new ClassPathXmlApplicationContext(configLocation, "topnb/applicationContext-interceptor.xml");
		}
		else {
			return new ClassPathXmlApplicationContext(configLocation);
		}
	}

	public static PerformanceHandler getPerformanceHandler() {
		return (PerformanceHandler) getBean("performanceHandler");
	}

	public static PerformanceService getPerformanceService() {
		return (PerformanceService) getBean("performanceService");
	}

	/**
	 * 获取bean对象.
	 * 
	 * @param beanName
	 *            bean名称
	 * @return
	 */
	public static Object getBean(String beanName) {
		return getApplicationContext().getBean(beanName);
	}

}
