/**
 * 多玩游戏 ©2005-2010. 多玩通行证系统 udb.duowan.com
 * @(#)MethodRunMessageInterceptor.java date:2011-6-13
 */
package io.leopard.topnb;

import io.leopard.topnb.service.PerformanceService;
import io.leopard.topnb.util.PerformanceUtil;

import java.lang.reflect.Method;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

/**
 * 方法耗时监控.
 * 
 * @author 阿海
 *
 */
public class TopnbInterceptor implements MethodInterceptor {

	private final PerformanceService performanceService = TopnbBeanFactory.getPerformanceService();

	private static boolean isCreated = false;

	public TopnbInterceptor() {
		if (isCreated) {
			throw new IllegalArgumentException("方法耗时监控系统已经启动.");
		}
		TopnbBeanFactory.setEnableMonitor(true);
	}

	@Override
	public Object invoke(MethodInvocation invocation) throws Throwable {
		Method method = invocation.getMethod();
		long startTime = System.nanoTime();
		Object result = invocation.proceed();
		long endTime = System.nanoTime();
		long time = (endTime - startTime) / 1000L; // time 单位:微妙
		Object target = invocation.getThis();

		String className = PerformanceUtil.getLongClassName(target);
		String methodName = PerformanceUtil.getLongMethodName(className, method.getName());

		performanceService.add(methodName, time);
		return result;
	}

}
