package io.leopard.topnb.controller;

import io.leopard.topnb.TopnbBeanFactory;
import io.leopard.topnb.detector.PerformanceAnomalyDetector;
import io.leopard.topnb.model.PerformanceVO;
import io.leopard.topnb.service.PerformanceHandler;
import io.leopard.topnb.service.PerformanceService;
import io.leopard.topnb.util.AvgTimePerformanceComparator;
import io.leopard.topnb.util.DefaultPerformanceComparator;
import io.leopard.topnb.util.TotalCountPerformanceComparator;
import io.leopard.topnb.util.TotalTimePerformanceComparator;
import io.leopard.topnb.view.FileView;
import io.leopard.topnb.view.FtlView;

import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * 性能监控数据
 * 
 * @author 阿海
 */
@Controller
public class TopnbController {

	protected Log logger = LogFactory.getLog(this.getClass());

	private PerformanceService performanceService = TopnbBeanFactory.getPerformanceService();

	private PerformanceHandler performanceHandler = TopnbBeanFactory.getPerformanceHandler();

	private Date serverStartTime = new Date();

	@RequestMapping("/topnb/index.do")
	public FtlView performance(String entryName, String order, String postdate, String proxyIp) {
		entryName = StringUtils.defaultString(entryName);

		List<PerformanceVO> performanceVOList = performanceHandler.list(entryName, postdate);
		List<String> entryNameList = performanceService.listAllEntryName();
		String typeName = performanceService.getTypeName(entryName);

		Collections.sort(performanceVOList, getComparator(order));

		FtlView view = new FtlView("/topnb/ftl/", "performance");
		view.addObject("performanceVOList", performanceVOList);
		view.addObject("entryNameList", entryNameList);

		view.addObject("serverStartTime", serverStartTime);
		view.addObject("serverIp", "127.0.0.1");

		view.addObject("currentEntryName", entryName);
		view.addObject("typeName", typeName);
		view.addObject("anomalyDetector", new PerformanceAnomalyDetector(performanceVOList));
		return view;
	}

	@RequestMapping("/topnb/file.do")
	public FileView file() {
		return new FileView("/topnb/htdocs/");
	}

	protected Comparator<PerformanceVO> getComparator(String order) {
		if ("totalTime".equals(order)) {
			return new TotalTimePerformanceComparator();
		}
		else if ("avgTime".equals(order)) {
			return new AvgTimePerformanceComparator();
		}
		else if ("totalCount".equals(order)) {
			return new TotalCountPerformanceComparator();
		}
		return new DefaultPerformanceComparator();
	}

}
