package io.leopard.topnb.data;

import io.leopard.topnb.model.Performance;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

/**
 * 方法耗时数据.
 * 
 * 入口:全部、入口1、入口2、入口3 时间:全部、今天、小时、分钟 速度(耗时)、全部、慢、特慢
 * 
 * @author 阿海
 * 
 */
public class BaseData implements Data {
	protected Log logger = LogFactory.getLog(this.getClass());

	protected final Map<String, Performance> DATA = new ConcurrentHashMap<String, Performance>();

	@Override
	public boolean add(String methodName, long time, int count) {
		if (StringUtils.isEmpty(methodName)) {
			throw new IllegalArgumentException("方法名称不能为空.");
		}

		if (DATA.size() >= 10000) {
			RuntimeException e = new RuntimeException("怎么方法数量会超过10000?");
			logger.error(e.getMessage(), e);

			logger.error("keys:" + DATA.keySet());
			return false;
		}
		// 访问频率比较高，速度比较快，且准确性不要求那么高，所以不加同步代码.
		Performance performace = DATA.get(methodName);
		if (performace == null) {
			performace = new Performance();
			performace.setMethodName(methodName);
		}
		performace.setTotalTime(performace.getTotalTime() + time);
		performace.setCount(performace.getCount() + count);
		DATA.put(methodName, performace);
		// System.err.println("add performance data,methodName:" + methodName +
		// " time:" + (time / 1000 ) + "ms " + time);
		return true;
	}

	public List<Performance> listAll() {
		Iterator<Performance> iterator = DATA.values().iterator();
		List<Performance> performaceList = new ArrayList<Performance>();
		while (iterator.hasNext()) {
			Performance performace = iterator.next();
			// System.out.println("performace:" + performace.getMethodName());
			performaceList.add(performace);
		}
		return performaceList;
	}

	public void clear() {
		DATA.clear();
	}
}
