package io.leopard.topnb.data;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/**
 * 入口数据.
 * 
 * @author ahai
 * 
 */
public class EntranceData implements Data {

	private final BaseData data = new BaseData();

	@Override
	public boolean add(String methodName, long time, int count) {
		String entryName = getCurrentEntryName();
		// System.err.println("add:" + entryName);
		if (entryName != null) {
			getDataByEntryName(entryName).add(methodName, time, count);
			this.incrCount(entryName);
		}
		data.add(methodName, time, count);
		return true;
	}

	private final Map<String, Long> countMap = new ConcurrentHashMap<String, Long>();
	private final Map<String, BaseData> map = new ConcurrentHashMap<String, BaseData>();

	protected String getCurrentEntryName() {
		ServletRequestAttributes requestAttributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
		if (requestAttributes == null) {
			return null;
		}
		HttpServletRequest request = requestAttributes.getRequest();
		return request.getRequestURI();
	}

	// public List<String> listAllEntryName() {
	// Set<String> set = map.keySet();
	// return ListUtil.toList(set);
	// }

	public BaseData getDataByEntryName(String entryName) {
		BaseData baseData = map.get(entryName);
		if (baseData == null) {
			baseData = new BaseData();
			map.put(entryName, baseData);
		}
		return baseData;
	}

	public BaseData getData() {
		return data;
	}

	protected void incrCount(String entryName) {
		long count = this.getCount(entryName);
		count++;
		countMap.put(entryName, count);
		// System.err.println("incrCount:" + entryName + " count:" + count);
	}

	public long getCount(String entryName) {
		Long count = countMap.get(entryName);
		if (count == null) {
			return 0;
		}
		return count;
	}

	public void clear() {
		this.data.clear();
		countMap.clear();
	}

}
