package io.leopard.topnb.detector;

import io.leopard.topnb.model.PerformanceVO;

import java.util.List;

/**
 * 方法耗时异常检查器.
 * 
 * @author 阿海
 * 
 */
public class PerformanceAnomalyDetector {

	protected List<PerformanceVO> performanceVOList;

	public PerformanceAnomalyDetector(List<PerformanceVO> performanceVOList) {
		this.performanceVOList = performanceVOList;
	}

	/**
	 * 检查平均耗时.
	 * 
	 * @param performanceVO
	 * @return
	 */
	public boolean checkAvgTime(PerformanceVO performanceVO) {
		if (performanceVO.getAvgTime() > 60 && performanceVO.getCount() > 100000) {
			return true;
		}
		return false;
	}

}
