package io.leopard.topnb.service;

import io.leopard.topnb.PerformanceStackTraceService;
import io.leopard.topnb.data.BaseData;
import io.leopard.topnb.data.EntranceData;
import io.leopard.topnb.model.Performance;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class PerformanceServiceImpl implements PerformanceService {

	@Autowired
	private EntranceData entranceData;

	@Override
	public boolean add(String methodName, long time) {
		int count = 1;
		entranceData.add(methodName, time, count);
		return true;
	}

	@Override
	public List<Performance> listAll(String entryName) {
		List<Performance> performanceList = this.getBaseData(entryName).listAll();
		this.filterIgnoreMethod(performanceList);
		return performanceList;
		// PerformanceDao performanceDao = this.getPerformanceDao(entryName);
		// List<Performance> performanceList = performanceDao.listAll();
		// performanceList = ListUtil.defaultList(performanceList);
		// // {
		// // Performance performance = new Performance();
		// // performance.setCount(10);
		// // performance.setMethodName("className.methodName1");
		// // performance.setTotalTime(11);
		// // performanceList.add(performance);
		// // }
		// return performanceList;
	}

	protected BaseData getBaseData(String entryName) {
		if (StringUtils.isEmpty(entryName)) {
			return entranceData.getData();
		}
		else {
			return entranceData.getDataByEntryName(entryName);
		}
	}

	private static final Set<String> IGNORE_METHOD = new HashSet<String>();
	static {
		IGNORE_METHOD.add("io.leopard.web.userinfo.service.UserinfoServiceImpl");
		IGNORE_METHOD.add("io.leopard.web.admin.dao.AdminLoginServiceImpl");
	}

	protected void filterIgnoreMethod(List<Performance> performanceList) {
		if (performanceList == null) {
			return;
		}
		Iterator<Performance> iterator = performanceList.iterator();
		while (iterator.hasNext()) {
			Performance performance = iterator.next();
			String methodName = performance.getMethodName();
			if (this.isIgnoreMethod(methodName)) {
				iterator.remove();
			}
		}
	}

	protected boolean isIgnoreMethod(String methodName) {
		for (String method : IGNORE_METHOD) {
			if (methodName.startsWith(method)) {
				return true;
			}
		}
		return false;
	}

	@Override
	public List<String> listAllEntryName() {
		// return this.stackService.listAllThreadName();
		List<String> entryNameList = PerformanceStackTraceService.listAllEntryName();
		this.sortEntryName(entryNameList);
		return sub(entryNameList, 10);
	}

	public static <T> List<T> sub(List<T> list, int max) {
		if (list == null || list.size() == 0) {
			return list;
		}
		List<T> newList = new ArrayList<T>();
		int count = 0;
		for (T element : list) {
			newList.add(element);
			count++;
			if (count >= max) {
				break;
			}
		}
		return newList;
	}

	protected void sortEntryName(List<String> entryNameList) {
		Collections.sort(entryNameList, new Comparator<String>() {
			@Override
			public int compare(String o1, String o2) {
				long count1 = getCount(o1);
				long count2 = getCount(o2);
				// System.err.println("count1:" + count1 + " count2:" + count2);
				long diff = count2 - count1;
				if (diff > 0) {
					return 1;
				}
				else if (diff < 0) {
					return -1;
				}
				else {
					return 0;
				}
			}
		});
	}

	protected long getCount(String entryName) {
		return entranceData.getCount(entryName);
	}

	@Override
	public String getTypeName(String entryName) {
		if (StringUtils.isEmpty(entryName)) {
			entryName = "全部入口";
		}
		return entryName;
	}

}
