package io.leopard.topnb.view;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class FileView extends ModelAndView {

	private AbstractUrlBasedView view = new AbstractUrlBasedView() {
		@Override
		protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
			FileView.this.renderMergedOutputModel(request, response);
		}
	};

	private String folder;

	public FileView(String folder) {
		this.folder = folder;
		super.setView(view);
	}

	protected void renderMergedOutputModel(HttpServletRequest request, HttpServletResponse response) throws Exception {
		String filename = request.getParameter("f");
		String contentType = this.parseContentType(filename);
		byte[] bytes = this.read(filename);
		response.setContentType(contentType);
		response.setContentLength(bytes.length);
		// Flush byte array to servlet output stream.

		OutputStream out = response.getOutputStream();
		out.write(bytes);
		out.flush();
	}

	private Pattern FILENAME_PATTERN = Pattern.compile("^[a-zA-Z0-9\\-_/]+\\.(css|jpg|png|js)$");

	/**
	 * 文件名称合法性判断.
	 * 
	 * @param filename
	 * @return
	 */
	protected boolean isValidFilename(String filename) {
		Matcher m = FILENAME_PATTERN.matcher(filename);
		return m.matches();
	}

	protected byte[] read(String filename) throws IOException {
		if (!this.isValidFilename(filename)) {
			throw new IllegalArgumentException("非法文件名[" + filename + "].");
		}
		String path = this.folder + filename;
		Resource resource = new ClassPathResource(path);
		InputStream input = resource.getInputStream();
		try {
			byte[] data = new byte[input.available()];
			input.read(data);
			return data;
		}
		finally {
			input.close();
		}
	}

	protected String parseContentType(String filename) {
		if (filename.endsWith(".css")) {
			return "text/css";
		}
		else if (filename.endsWith(".png")) {
			return "image/png";
		}
		else if (filename.endsWith(".jpg")) {
			return "image/jpg";
		}
		else if (filename.endsWith(".js")) {
			return "text/javascript";
		}
		throw new IllegalArgumentException("未知文件类型[" + filename + "].");
	}
}
