
	$(function() {
		$("#selectable").selectable();
	});

	function mousewheelbind(id, max) {
		$('#'+id).mousewheel(function(e){
	        var isUp = e.deltaY < 0;
	        var obj = document.getElementById(id);
	        var num = obj.innerHTML;
	        num = num.replace(/^0/,"");
	        num = parseInt(num);
	        
	        if (isUp) {
	        	if (num<max) {
	        		num++;
	        	}
	        }
	        else {
	        	if (num>0) {
	        		num--;
	        	}
	        }
	        obj.innerHTML = fixedLength(num);
	    });
	}
	
	function fixedLength(num) {
		if (num < 10) {
        	num = "0" + num;
        }
		return num;
	}
	
	mousewheelbind('clockHour', 23);
	mousewheelbind('clockMinute', 59);
	mousewheelbind('clockSecond', 59);

	function refreshClock() {
		var now = new Date();  
		var year = now.getYear();
		var month = now.getMonth();
		var day = now.getDay();
		var hour = now.getHours();  
		var minute = now.getMinutes();  
		var second = now.getSeconds();  
		
		var time = fixedLength(year) + "-" + fixedLength(month) + "-" + fixedLength(day);
		time += " "+fixedLength(hour) + ":" + fixedLength(minute) + ":" + fixedLength(second);

		document.getElementById("clock_currentTime").innerHTML = "系统时间:"+time;
		
		document.getElementById("clockHour").innerHTML = fixedLength(hour);
		document.getElementById("clockMinute").innerHTML = fixedLength(minute);
		document.getElementById("clockSecond").innerHTML = fixedLength(second);
		
	}
	refreshClock();
	var clockInterval = setInterval("refreshClock()", 1000);
	