/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.topnb;

import io.leopard.topnb.service.PerformanceHandler;
import io.leopard.topnb.service.PerformanceService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class TopnbBeanFactory {
    protected static final Log logger = LogFactory.getLog(TopnbBeanFactory.class);
    private static AbstractApplicationContext applicationContext;
    private static boolean isEnableMonitor;

    protected static synchronized AbstractApplicationContext getApplicationContext() {
        if (applicationContext == null) {
            String[] filenames = new String[]{"/topnb/applicationContext-service.xml"};
            applicationContext = new ClassPathXmlApplicationContext(filenames);
        }
        return applicationContext;
    }

    public static boolean isEnableMonitor() {
        return isEnableMonitor;
    }

    public static void setEnableMonitor(boolean isEnableMonitor) {
        TopnbBeanFactory.isEnableMonitor = isEnableMonitor;
    }

    public static ClassPathXmlApplicationContext getContext(String configLocation) {
        boolean isEnableMonitor = TopnbBeanFactory.isEnableMonitor();
        return TopnbBeanFactory.getContext(configLocation, isEnableMonitor);
    }

    protected static ClassPathXmlApplicationContext getContext(String configLocation, boolean isEnableMonitor) {
        if (isEnableMonitor) {
            return new ClassPathXmlApplicationContext(new String[]{configLocation, "topnb/applicationContext-interceptor.xml"});
        }
        return new ClassPathXmlApplicationContext(configLocation);
    }

    public static PerformanceHandler getPerformanceHandler() {
        return (PerformanceHandler)TopnbBeanFactory.getBean("performanceHandler");
    }

    public static PerformanceService getPerformanceService() {
        return (PerformanceService)TopnbBeanFactory.getBean("performanceService");
    }

    public static Object getBean(String beanName) {
        return TopnbBeanFactory.getApplicationContext().getBean(beanName);
    }

    static {
        isEnableMonitor = false;
    }
}

