/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.topnb;

import io.leopard.topnb.TopnbBeanFactory;
import io.leopard.topnb.service.PerformanceService;
import io.leopard.topnb.util.PerformanceUtil;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class TopnbInterceptor
implements MethodInterceptor {
    private final PerformanceService performanceService = TopnbBeanFactory.getPerformanceService();
    private static boolean isCreated = false;

    public TopnbInterceptor() {
        if (isCreated) {
            throw new IllegalArgumentException("\u65b9\u6cd5\u8017\u65f6\u76d1\u63a7\u7cfb\u7edf\u5df2\u7ecf\u542f\u52a8.");
        }
        TopnbBeanFactory.setEnableMonitor(true);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        long startTime = System.nanoTime();
        Object result = invocation.proceed();
        long endTime = System.nanoTime();
        long time = (endTime - startTime) / 1000L;
        Object target = invocation.getThis();
        String className = PerformanceUtil.getLongClassName(target);
        String methodName = PerformanceUtil.getLongMethodName(className, method.getName());
        this.performanceService.add(methodName, time);
        return result;
    }
}

