/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.topnb.data;

import io.leopard.topnb.data.BaseData;
import io.leopard.topnb.data.Data;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class EntranceData
implements Data {
    private final BaseData data = new BaseData();
    private final Map<String, Long> countMap = new ConcurrentHashMap<String, Long>();
    private final Map<String, BaseData> map = new ConcurrentHashMap<String, BaseData>();

    @Override
    public boolean add(String methodName, long time, int count) {
        String entryName = this.getCurrentEntryName();
        if (entryName != null) {
            this.getDataByEntryName(entryName).add(methodName, time, count);
            this.incrCount(entryName);
        }
        this.data.add(methodName, time, count);
        return true;
    }

    protected String getCurrentEntryName() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return null;
        }
        HttpServletRequest request = requestAttributes.getRequest();
        return request.getRequestURI();
    }

    public BaseData getDataByEntryName(String entryName) {
        BaseData baseData = this.map.get(entryName);
        if (baseData == null) {
            baseData = new BaseData();
            this.map.put(entryName, baseData);
        }
        return baseData;
    }

    public BaseData getData() {
        return this.data;
    }

    protected void incrCount(String entryName) {
        long count = this.getCount(entryName);
        this.countMap.put(entryName, ++count);
    }

    public long getCount(String entryName) {
        Long count = this.countMap.get(entryName);
        if (count == null) {
            return 0L;
        }
        return count;
    }

    public void clear() {
        this.data.clear();
        this.countMap.clear();
    }
}

