/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.topnb.service;

import io.leopard.topnb.model.Performance;
import io.leopard.topnb.model.PerformanceVO;
import io.leopard.topnb.service.PerformanceHandler;
import io.leopard.topnb.service.PerformanceService;
import io.leopard.topnb.util.DefaultPerformanceComparator;
import io.leopard.topnb.util.PerformanceUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PerformanceHandlerImpl
implements PerformanceHandler {
    protected Log logger = LogFactory.getLog(this.getClass());
    @Autowired
    private PerformanceService performanceService;

    @Override
    public List<PerformanceVO> list(String entryName, String postdate) {
        List<Performance> performanceList = this.performanceService.listAll(entryName);
        if (performanceList == null || performanceList.size() == 0) {
            return new ArrayList<PerformanceVO>();
        }
        ArrayList<PerformanceVO> performanceVOList = new ArrayList<PerformanceVO>();
        for (Performance performance : performanceList) {
            performanceVOList.add(this.toPerformanceVO(performance));
        }
        this.ratio(performanceVOList, entryName);
        Collections.sort(performanceVOList, new DefaultPerformanceComparator());
        return performanceVOList;
    }

    protected Map<String, Long> getModuleTotalTime(List<PerformanceVO> performanceVOList) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (PerformanceVO performanceVO : performanceVOList) {
            String moduleName = performanceVO.getModuleName();
            Long totalTime = (Long)map.get(moduleName);
            if (totalTime == null) {
                totalTime = 0L;
            }
            totalTime = totalTime + performanceVO.getTotalTime();
            map.put(moduleName, totalTime);
        }
        return map;
    }

    protected Map<String, Long> getInterfaceTotalTime(List<PerformanceVO> performanceVOList) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (PerformanceVO performanceVO : performanceVOList) {
            String simpleClassName = performanceVO.getSimpleClassName();
            if (simpleClassName.endsWith("CacheImpl")) continue;
            String interfaceName = performanceVO.getInterfaceName();
            Long totalTime = (Long)map.get(interfaceName);
            if (totalTime == null) {
                totalTime = 0L;
            }
            totalTime = totalTime + performanceVO.getTotalTime();
            map.put(interfaceName, totalTime);
        }
        return map;
    }

    protected long getAllTotalTime(List<PerformanceVO> performanceVOList, String threadName) {
        long totalTime = 0L;
        if (StringUtils.isNotEmpty((String)threadName)) {
            totalTime = this.getAllTotalTimeByEntry(performanceVOList);
            if (totalTime > -1L) {
                return totalTime;
            }
            totalTime = 0L;
        }
        for (PerformanceVO performanceVO : performanceVOList) {
            totalTime += performanceVO.getTotalTime();
        }
        return totalTime;
    }

    protected long getAllTotalTimeByEntry(List<PerformanceVO> performanceVOList) {
        for (PerformanceVO performanceVO : performanceVOList) {
            if (!this.isController(performanceVO.getMethodName())) continue;
            return performanceVO.getTotalTime();
        }
        return -1L;
    }

    protected void ratio(List<PerformanceVO> performanceVOList, String entryName) {
        long allTotalTime = this.getAllTotalTime(performanceVOList, entryName);
        Map<String, Long> moduleTotalTimeMap = this.getModuleTotalTime(performanceVOList);
        Map<String, Long> interfaceTotalTimeMap = this.getInterfaceTotalTime(performanceVOList);
        for (PerformanceVO performanceVO : performanceVOList) {
            String moduleName = performanceVO.getModuleName();
            String interfaceName = performanceVO.getInterfaceName();
            Long interfaceTotalTime = interfaceTotalTimeMap.get(interfaceName);
            double interfaceRatio = this.percent(performanceVO.getTotalTime(), interfaceTotalTime);
            double moduleRatio = this.percent(performanceVO.getTotalTime(), moduleTotalTimeMap.get(moduleName));
            double timeRatio = this.percent(performanceVO.getTotalTime(), allTotalTime);
            performanceVO.setInterfaceRatio(interfaceRatio);
            performanceVO.setModuleRatio(moduleRatio);
            performanceVO.setTimeRatio(timeRatio);
        }
    }

    protected double percent(double current, Long total) {
        if (current == 0.0) {
            return 0.0;
        }
        if (total == null || total == 0L) {
            return 0.0;
        }
        double avg = current / (double)total.longValue();
        double percent = avg * 100.0;
        String percent2 = new DecimalFormat(".0").format(percent);
        return Double.parseDouble(percent2);
    }

    public static long perSecondAvg(long count, long time) {
        if (time <= 0L) {
            return 0L;
        }
        return count * 1000L / time;
    }

    protected PerformanceVO toPerformanceVO(Performance performance) {
        PerformanceVO performanceVO = new PerformanceVO();
        int threadSize = 1;
        String longMethodName = performance.getMethodName();
        long totalCount = performance.getCount();
        Long totalMilliSeconds = performance.getTotalTime() / 1000L / (long)threadSize;
        long totalSeconds = totalMilliSeconds / 1000L;
        long avgCount = PerformanceHandlerImpl.perSecondAvg(totalCount, totalMilliSeconds);
        double avgTime = PerformanceUtil.avgTime(totalCount, totalMilliSeconds);
        String categoryName = PerformanceUtil.getModuleName(longMethodName);
        String moduleName = PerformanceUtil.getModuleName(longMethodName);
        String interfaceName = PerformanceUtil.getInterfaceName(longMethodName);
        String simpleMethodName = PerformanceUtil.parseSimpleMethodName(longMethodName);
        String simpleClassName = PerformanceUtil.parseSimpleClassName(longMethodName);
        performanceVO.setCount(totalCount);
        performanceVO.setTotalTime(performance.getTotalTime());
        performanceVO.setMethodName(longMethodName);
        performanceVO.setSimpleMethodName(simpleMethodName);
        performanceVO.setSimpleClassName(simpleClassName);
        performanceVO.setTotalSeconds(totalSeconds);
        performanceVO.setTotalMilliSeconds(totalMilliSeconds);
        performanceVO.setAvgCount(avgCount);
        performanceVO.setAvgTime(avgTime);
        performanceVO.setModuleName(moduleName);
        performanceVO.setCategoryName(categoryName);
        performanceVO.setInterfaceName(interfaceName);
        return performanceVO;
    }

    private boolean isController(String longMethodName) {
        String className = PerformanceUtil.parseClassName(longMethodName);
        return className.endsWith("Controller") && !className.endsWith("ErrorController");
    }
}

