/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.topnb.service;

import io.leopard.topnb.PerformanceStackTraceService;
import io.leopard.topnb.data.BaseData;
import io.leopard.topnb.data.EntranceData;
import io.leopard.topnb.model.Performance;
import io.leopard.topnb.service.PerformanceService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class PerformanceServiceImpl
implements PerformanceService {
    @Autowired
    private EntranceData entranceData;
    private static final Set<String> IGNORE_METHOD = new HashSet<String>();

    @Override
    public boolean add(String methodName, long time) {
        int count = 1;
        this.entranceData.add(methodName, time, count);
        return true;
    }

    @Override
    public List<Performance> listAll(String entryName) {
        List<Performance> performanceList = this.getBaseData(entryName).listAll();
        this.filterIgnoreMethod(performanceList);
        return performanceList;
    }

    protected BaseData getBaseData(String entryName) {
        if (StringUtils.isEmpty((String)entryName)) {
            return this.entranceData.getData();
        }
        return this.entranceData.getDataByEntryName(entryName);
    }

    protected void filterIgnoreMethod(List<Performance> performanceList) {
        if (performanceList == null) {
            return;
        }
        Iterator<Performance> iterator = performanceList.iterator();
        while (iterator.hasNext()) {
            Performance performance = iterator.next();
            String methodName = performance.getMethodName();
            if (!this.isIgnoreMethod(methodName)) continue;
            iterator.remove();
        }
    }

    protected boolean isIgnoreMethod(String methodName) {
        for (String method : IGNORE_METHOD) {
            if (!methodName.startsWith(method)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> listAllEntryName() {
        List<String> entryNameList = PerformanceStackTraceService.listAllEntryName();
        this.sortEntryName(entryNameList);
        return PerformanceServiceImpl.sub(entryNameList, 10);
    }

    public static <T> List<T> sub(List<T> list, int max) {
        if (list == null || list.size() == 0) {
            return list;
        }
        ArrayList<T> newList = new ArrayList<T>();
        int count = 0;
        for (T element : list) {
            newList.add(element);
            if (++count < max) continue;
            break;
        }
        return newList;
    }

    protected void sortEntryName(List<String> entryNameList) {
        Collections.sort(entryNameList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                long count1 = PerformanceServiceImpl.this.getCount(o1);
                long count2 = PerformanceServiceImpl.this.getCount(o2);
                long diff = count2 - count1;
                if (diff > 0L) {
                    return 1;
                }
                if (diff < 0L) {
                    return -1;
                }
                return 0;
            }
        });
    }

    protected long getCount(String entryName) {
        return this.entranceData.getCount(entryName);
    }

    @Override
    public String getTypeName(String entryName) {
        if (StringUtils.isEmpty((String)entryName)) {
            entryName = "\u5168\u90e8\u5165\u53e3";
        }
        return entryName;
    }

    static {
        IGNORE_METHOD.add("io.leopard.web.userinfo.service.UserinfoServiceImpl");
        IGNORE_METHOD.add("io.leopard.web.admin.dao.AdminLoginServiceImpl");
    }
}

