/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.topnb.util;

import freemarker.template.utility.ClassUtil;
import io.leopard.topnb.PerformanceCategory;
import io.leopard.topnb.PerformanceModuleEnum;
import java.text.DecimalFormat;
import java.util.Date;

public class PerformanceUtil {
    protected static Date SYSTEM_START_TIME = new Date();

    public static Date getSystemStartTime() {
        return SYSTEM_START_TIME;
    }

    public static String getModuleName(String methodName) {
        String categoryName = PerformanceUtil.getCategoryName(methodName);
        if ("DaoCacheImpl".equals(categoryName)) {
            return PerformanceModuleEnum.DAOCACHEIMPL.getDesc();
        }
        if (categoryName.startsWith("Dao")) {
            return PerformanceModuleEnum.DAO.getDesc();
        }
        if ("\u672a\u77e5\u5206\u7c7b".equals(categoryName)) {
            return PerformanceModuleEnum.UNKNOWN.getDesc();
        }
        return categoryName;
    }

    protected static boolean isLeopardBean(String simpleMethodName) {
        if (simpleMethodName.startsWith("UserinfoServiceImpl.")) {
            return true;
        }
        if (simpleMethodName.startsWith("LoginServiceImpl.")) {
            return true;
        }
        if (simpleMethodName.startsWith("AdminLoginServiceImpl.")) {
            return true;
        }
        if (simpleMethodName.startsWith("AdminLoginDaoMysqlImpl.")) {
            return true;
        }
        return simpleMethodName.startsWith("UserinfoFilter.");
    }

    public static int getCategoryOrderByMethodName(String methodName) {
        String categoryName = PerformanceUtil.getCategoryName(methodName);
        return PerformanceCategory.toEnumByDesc(categoryName).getKey();
    }

    public static String getCategoryName(String longMethodName) {
        String simpleMethodName = PerformanceUtil.parseSimpleMethodName(longMethodName);
        if (PerformanceUtil.isLeopardBean(simpleMethodName)) {
            return PerformanceCategory.LEOPARD.getDesc();
        }
        if (simpleMethodName.indexOf("OutsideDao") != -1) {
            return PerformanceCategory.OUTSIDE.getDesc();
        }
        if (simpleMethodName.indexOf("DaoMysqlImpl.") != -1) {
            return PerformanceCategory.DAOMYSQLIMPL.getDesc();
        }
        if (simpleMethodName.indexOf("DaoMemoryImpl.") != -1) {
            return PerformanceCategory.DAOMEMORYIMPL.getDesc();
        }
        if (simpleMethodName.indexOf("DaoCacheImpl.") != -1) {
            return PerformanceCategory.DAOCACHEIMPL.getDesc();
        }
        if (simpleMethodName.indexOf("DaoRedisImpl.") != -1) {
            return PerformanceCategory.DAOREDISIMPL.getDesc();
        }
        if (simpleMethodName.indexOf("DaoMemcachedImpl.") != -1) {
            return PerformanceCategory.DAOMEMCACHEDIMPL.getDesc();
        }
        if (simpleMethodName.indexOf("DaoHttpImpl.") != -1) {
            return PerformanceCategory.OUTSIDE.getDesc();
        }
        if (simpleMethodName.indexOf("DaoOutsideImpl.") != -1) {
            return PerformanceCategory.OUTSIDE.getDesc();
        }
        if (simpleMethodName.indexOf("ServiceImpl.") != -1) {
            return PerformanceCategory.SERVICE.getDesc();
        }
        if (simpleMethodName.indexOf("HandlerImpl.") != -1) {
            return PerformanceCategory.HANDLER.getDesc();
        }
        if (simpleMethodName.indexOf("Controller.") != -1) {
            return PerformanceCategory.Controller.getDesc();
        }
        if (simpleMethodName.indexOf("ControllerImpl.") != -1) {
            return PerformanceCategory.Controller.getDesc();
        }
        if (simpleMethodName.startsWith("RedisImpl.")) {
            return PerformanceCategory.DATASOURCE.getDesc();
        }
        if (simpleMethodName.startsWith("Base64.")) {
            return PerformanceCategory.ENCODER.getDesc();
        }
        if (simpleMethodName.startsWith("Base16.")) {
            return PerformanceCategory.ENCODER.getDesc();
        }
        if (simpleMethodName.startsWith("Json.")) {
            return PerformanceCategory.ENCODER.getDesc();
        }
        if (simpleMethodName.startsWith("SessionService.")) {
            return PerformanceCategory.LEOPARD.getDesc();
        }
        if (simpleMethodName.startsWith("EncryptUtil.")) {
            return PerformanceCategory.ENCODER.getDesc();
        }
        return PerformanceCategory.UNKNOWN.getDesc();
    }

    public static double avgTime(long totalCount, long totalMilliSeconds) {
        double avg = (double)totalMilliSeconds * 1.0 / (double)totalCount;
        return PerformanceUtil.formatAvgTime(avg);
    }

    public static double formatAvgTime(double avg) {
        String avgTime = avg < 0.01 ? new DecimalFormat(",000").format(avg) : (avg < 0.1 ? new DecimalFormat(",00").format(avg) : new DecimalFormat(".").format(avg));
        return Double.parseDouble(avgTime);
    }

    public static String getLongClassName(Object target) {
        return target.getClass().getName();
    }

    public static String getLongMethodName(String className, String methodName) {
        StringBuilder sb = new StringBuilder(className.length() + methodName.length() + 1);
        sb.append(className).append('.').append(methodName);
        return sb.toString();
    }

    public static String parseClassName(String longMethodName) {
        int index = longMethodName.lastIndexOf(".");
        return longMethodName.substring(0, index);
    }

    public static String parseSimpleMethodName(String longMethodName) {
        String className = PerformanceUtil.parseClassName(longMethodName);
        int index = className.lastIndexOf(".");
        String simpleMethodName = longMethodName.substring(index + 1);
        return simpleMethodName;
    }

    public static String parseSimpleClassName(String longMethodName) {
        String className = PerformanceUtil.parseClassName(longMethodName);
        int index = className.lastIndexOf("$");
        if (index == -1) {
            index = className.lastIndexOf(".");
        }
        String simpleClassName = className.substring(index + 1);
        return simpleClassName;
    }

    public static String getInterfaceName(String longMethodName) {
        Class<?>[] classes;
        Class clazz;
        String className = PerformanceUtil.parseClassName(longMethodName);
        String simpleClassName = PerformanceUtil.parseSimpleClassName(longMethodName);
        if (className.indexOf("$Proxy") != -1) {
            return "$Proxy";
        }
        try {
            clazz = ClassUtil.forName((String)className);
        }
        catch (ClassNotFoundException e) {
            System.err.println("longMethodName:" + longMethodName);
            throw new RuntimeException(e.getMessage(), e);
        }
        for (Class<?> cls : classes = clazz.getInterfaces()) {
            String simpleName = cls.getSimpleName();
            if (!simpleClassName.startsWith(simpleName)) continue;
            return cls.getName();
        }
        return className;
    }
}

