/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.topnb.view;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class FileView
extends ModelAndView {
    private AbstractUrlBasedView view = new AbstractUrlBasedView(){

        protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
            FileView.this.renderMergedOutputModel(request, response);
        }
    };
    private String folder;
    private Pattern FILENAME_PATTERN = Pattern.compile("^[a-zA-Z0-9\\-_/]+\\.(css|jpg|png|js)$");

    public FileView(String folder) {
        this.folder = folder;
        super.setView((View)this.view);
    }

    protected void renderMergedOutputModel(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String filename = request.getParameter("f");
        String contentType = this.parseContentType(filename);
        byte[] bytes = this.read(filename);
        response.setContentType(contentType);
        response.setContentLength(bytes.length);
        ServletOutputStream out = response.getOutputStream();
        out.write(bytes);
        out.flush();
    }

    protected boolean isValidFilename(String filename) {
        Matcher m = this.FILENAME_PATTERN.matcher(filename);
        return m.matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] read(String filename) throws IOException {
        if (!this.isValidFilename(filename)) {
            throw new IllegalArgumentException("\u975e\u6cd5\u6587\u4ef6\u540d[" + filename + "].");
        }
        String path = this.folder + filename;
        ClassPathResource resource = new ClassPathResource(path);
        InputStream input = resource.getInputStream();
        try {
            byte[] data = new byte[input.available()];
            input.read(data);
            byte[] byArray = data;
            return byArray;
        }
        finally {
            input.close();
        }
    }

    protected String parseContentType(String filename) {
        if (filename.endsWith(".css")) {
            return "text/css";
        }
        if (filename.endsWith(".png")) {
            return "image/png";
        }
        if (filename.endsWith(".jpg")) {
            return "image/jpg";
        }
        if (filename.endsWith(".js")) {
            return "text/javascript";
        }
        throw new IllegalArgumentException("\u672a\u77e5\u6587\u4ef6\u7c7b\u578b[" + filename + "].");
    }
}

