/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.topnb.view;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import io.leopard.topnb.view.FreeMarkerUtil;
import java.io.IOException;
import java.util.Locale;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfig;
import org.springframework.web.servlet.view.freemarker.FreeMarkerView;

public class FtlView
extends FreeMarkerView {
    private final String folder;

    public FtlView(String viewName) {
        this("/", viewName);
    }

    public FtlView(String folder, String viewName) {
        try {
            WebApplicationContext applicationContext = ContextLoader.getCurrentWebApplicationContext();
            this.setApplicationContext((ApplicationContext)applicationContext);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setUrl(viewName + ".ftl");
        this.folder = folder;
    }

    public void addObject(String name, Object value) {
        this.addStaticAttribute(name, value);
    }

    protected FreeMarkerConfig autodetectConfiguration() throws BeansException {
        return FreeMarkerUtil.getFreeMarkerConfig();
    }

    public String getContentType() {
        return "text/html; charset=UTF-8";
    }

    protected Template getTemplate(String name, Locale locale) throws IOException {
        Configuration conf = this.getConfiguration();
        conf.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(((Object)((Object)this)).getClass(), this.folder));
        Template tmp = this.getEncoding() != null ? conf.getTemplate(name, locale, this.getEncoding()) : conf.getTemplate(name, locale);
        return tmp;
    }
}

