/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.topnb.view;

import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ReplaceParamMethod
implements TemplateMethodModelEx {
    private static final Pattern pattern = Pattern.compile("([a-zA-Z0-9_]+)=([a-zA-Z0-9_]+)");

    public Object exec(List args) throws TemplateModelException {
        String param = args.get(0).toString();
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        return this.replaceParam(param, request);
    }

    protected String replaceParam(String param, HttpServletRequest request) {
        Matcher m = pattern.matcher(param);
        if (!m.find()) {
            throw new IllegalArgumentException("\u975e\u6cd5\u53c2\u6570[" + param + "].");
        }
        String key = m.group(1);
        String value = m.group(2);
        return this.getQueryString(request, key, value);
    }

    protected String getQueryString(HttpServletRequest request, String key, String value) {
        StringBuilder sb = new StringBuilder();
        Enumeration e = request.getParameterNames();
        boolean hasReplace = false;
        while (e.hasMoreElements()) {
            String value2;
            String name = (String)e.nextElement();
            if (name.equals(key)) {
                value2 = value;
                hasReplace = true;
            } else {
                value2 = request.getParameter(name);
            }
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(name).append("=").append(value2);
        }
        if (!hasReplace) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(key).append("=").append(value);
        }
        return "?" + sb.toString();
    }
}

