/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.javahost.impl;

import io.leopard.javahost.Hosts;
import io.leopard.javahost.model.Host;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractHosts
implements Hosts {
    protected String getHostsPath() {
        String path = System.getProperty("os.name").startsWith("Windows") ? "c:/windows/System32/drivers/etc/hosts" : "/etc/hosts";
        return path;
    }

    protected String readHostsFile() throws IOException {
        String line;
        String path = this.getHostsPath();
        BufferedReader reader = new BufferedReader(new FileReader(path));
        StringBuilder sb = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            sb.append(line).append("\n");
        }
        reader.close();
        return sb.toString();
    }

    protected List<Host> parseLine(String line) {
        line = line.trim();
        line = line.replaceFirst("#.*$", "");
        ArrayList<Host> list = new ArrayList<Host>();
        if (line.length() == 0) {
            return list;
        }
        String[] hosts = line.split("\\s+");
        if (hosts.length < 2) {
            throw new RuntimeException("\u975e\u6cd5host\u8bb0\u5f55[" + line + "].");
        }
        for (int i = 1; i < hosts.length; ++i) {
            Host host = new Host();
            host.setIp(hosts[0]);
            host.setHost(hosts[i]);
            list.add(host);
        }
        return list;
    }
}

